/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.analyzer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.core.rule.Rule;

public final class AnalyzerRules {
    public static List<Attribute> maybeResolveAgainstList(UnresolvedAttribute u, Collection<Attribute> attrList, Function<Attribute, Attribute> fieldInspector) {
        String qualifier = u.qualifier();
        String name = u.name();
        boolean qualified = u.qualifier() != null;
        Predicate<Attribute> predicate = a -> qualified ? Objects.equals(qualifier, a.qualifiedName()) : Objects.equals(name, a.name()) || Objects.equals(name, a.qualifiedName());
        return AnalyzerRules.maybeResolveAgainstList(predicate, () -> u, attrList, false, fieldInspector);
    }

    public static List<Attribute> maybeResolveAgainstList(Predicate<Attribute> matcher, Supplier<UnresolvedAttribute> unresolved, Collection<Attribute> attrList, boolean isPattern, Function<Attribute, Attribute> fieldInspector) {
        ArrayList<Attribute> matches = new ArrayList<Attribute>();
        for (Attribute attribute : attrList) {
            boolean match;
            if (attribute.synthetic() || !(match = matcher.test(attribute))) continue;
            matches.add(attribute);
        }
        if (matches.isEmpty()) {
            return matches;
        }
        UnresolvedAttribute ua = unresolved.get();
        if (matches.size() == 1 || isPattern) {
            matches.replaceAll(e -> (Attribute)fieldInspector.apply((Attribute)e));
            return matches;
        }
        List<String> refs = matches.stream().sorted((a, b) -> {
            int lineDiff = a.sourceLocation().getLineNumber() - b.sourceLocation().getLineNumber();
            int colDiff = a.sourceLocation().getColumnNumber() - b.sourceLocation().getColumnNumber();
            return lineDiff != 0 ? lineDiff : (colDiff != 0 ? colDiff : a.qualifiedName().compareTo(b.qualifiedName()));
        }).map(a -> "line " + a.sourceLocation().toString().substring(1) + " [" + (String)(a.qualifier() != null ? "\"" + a.qualifier() + "\".\"" + a.name() + "\"" : a.name()) + "]").toList();
        throw new IllegalStateException("Reference [" + ua.qualifiedName() + "] is ambiguous; matches any of " + refs);
    }

    public static abstract class BaseAnalyzerRule
    extends AnalyzerRule<LogicalPlan> {
        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    public static abstract class ParameterizedAnalyzerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static abstract class AnalyzerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule(t));
        }

        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }
}

