/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;

public class MultiTypeEsField
extends EsField {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(EsField.class, "MultiTypeEsField", MultiTypeEsField::new);
    private final Map<String, Expression> indexToConversionExpressions;

    public MultiTypeEsField(String name, DataType dataType, boolean aggregatable, Map<String, Expression> indexToConversionExpressions) {
        super(name, dataType, Map.of(), aggregatable);
        this.indexToConversionExpressions = indexToConversionExpressions;
    }

    public MultiTypeEsField(StreamInput in) throws IOException {
        this(in.readString(), DataType.readFrom((StreamInput)in), in.readBoolean(), in.readImmutableMap(i -> (Expression)i.readNamedWriteable(Expression.class)));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getName());
        out.writeString(this.getDataType().typeName());
        out.writeBoolean(this.isAggregatable());
        out.writeMap(this.getIndexToConversionExpressions(), (o, v) -> out.writeNamedWriteable((NamedWriteable)v));
    }

    public String getWriteableName() {
        return MultiTypeEsField.ENTRY.name;
    }

    public Map<String, Expression> getIndexToConversionExpressions() {
        return this.indexToConversionExpressions;
    }

    public Expression getConversionExpressionForIndex(String indexName) {
        return this.indexToConversionExpressions.get(indexName);
    }

    public static MultiTypeEsField resolveFrom(InvalidMappedField invalidMappedField, Map<String, Expression> typesToConversionExpressions) {
        Map typesToIndices = invalidMappedField.getTypesToIndices();
        DataType resolvedDataType = DataType.UNSUPPORTED;
        HashMap<String, Expression> indexToConversionExpressions = new HashMap<String, Expression>();
        for (String typeName : typesToIndices.keySet()) {
            Set indices = (Set)typesToIndices.get(typeName);
            Expression convertExpr = typesToConversionExpressions.get(typeName);
            if (resolvedDataType == DataType.UNSUPPORTED) {
                resolvedDataType = convertExpr.dataType();
            } else if (resolvedDataType != convertExpr.dataType()) {
                throw new IllegalArgumentException("Resolved data type mismatch: " + resolvedDataType + " != " + convertExpr.dataType());
            }
            for (String indexName : indices) {
                indexToConversionExpressions.put(indexName, convertExpr);
            }
        }
        return new MultiTypeEsField(invalidMappedField.getName(), resolvedDataType, false, indexToConversionExpressions);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof MultiTypeEsField) {
            MultiTypeEsField other = (MultiTypeEsField)((Object)obj);
            return super.equals((Object)other) && this.indexToConversionExpressions.equals(other.indexToConversionExpressions);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.indexToConversionExpressions);
    }

    public String toString() {
        return super.toString() + " (" + this.indexToConversionExpressions + ")";
    }
}

