/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.util.Locale;
import org.elasticsearch.xpack.esql.core.type.DataType;

public final class EsqlDataTypes {
    private EsqlDataTypes() {
    }

    public static DataType fromTypeName(String name) {
        return DataType.fromTypeName((String)name.toLowerCase(Locale.ROOT));
    }

    public static boolean isString(DataType t) {
        return t == DataType.KEYWORD || t == DataType.TEXT;
    }

    public static boolean isPrimitive(DataType t) {
        return t != DataType.OBJECT && t != DataType.NESTED;
    }

    public static boolean isDateTimeOrTemporal(DataType t) {
        return DataType.isDateTime((DataType)t) || EsqlDataTypes.isTemporalAmount(t);
    }

    public static boolean isTemporalAmount(DataType t) {
        return t == DataType.DATE_PERIOD || t == DataType.TIME_DURATION;
    }

    public static boolean isNullOrTemporalAmount(DataType t) {
        return EsqlDataTypes.isTemporalAmount(t) || DataType.isNull((DataType)t);
    }

    public static boolean isNullOrDatePeriod(DataType t) {
        return t == DataType.DATE_PERIOD || DataType.isNull((DataType)t);
    }

    public static boolean isNullOrTimeDuration(DataType t) {
        return t == DataType.TIME_DURATION || DataType.isNull((DataType)t);
    }

    public static boolean isSpatial(DataType t) {
        return t == DataType.GEO_POINT || t == DataType.CARTESIAN_POINT || t == DataType.GEO_SHAPE || t == DataType.CARTESIAN_SHAPE;
    }

    public static boolean isSpatialGeo(DataType t) {
        return t == DataType.GEO_POINT || t == DataType.GEO_SHAPE;
    }

    public static boolean isSpatialPoint(DataType t) {
        return t == DataType.GEO_POINT || t == DataType.CARTESIAN_POINT;
    }

    public static boolean isRepresentable(DataType t) {
        return t != DataType.OBJECT && t != DataType.NESTED && t != DataType.UNSUPPORTED && t != DataType.DATE_PERIOD && t != DataType.TIME_DURATION && t != DataType.BYTE && t != DataType.SHORT && t != DataType.FLOAT && t != DataType.SCALED_FLOAT && t != DataType.SOURCE && t != DataType.HALF_FLOAT && t != DataType.PARTIAL_AGG && !t.isCounter();
    }

    public static boolean areCompatible(DataType left, DataType right) {
        if (left == right) {
            return true;
        }
        return left == DataType.NULL || right == DataType.NULL || EsqlDataTypes.isString(left) && EsqlDataTypes.isString(right) || left.isNumeric() && right.isNumeric();
    }
}

