/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.util.Collection;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeRegistry;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class EsqlDataTypeRegistry
implements DataTypeRegistry {
    public static final DataTypeRegistry INSTANCE = new EsqlDataTypeRegistry();

    private EsqlDataTypeRegistry() {
    }

    public Collection<DataType> dataTypes() {
        return DataType.types();
    }

    public DataType fromEs(String typeName, TimeSeriesParams.MetricType metricType) {
        DataType type = DataType.fromEs((String)typeName);
        return metricType == TimeSeriesParams.MetricType.COUNTER ? type.widenSmallNumeric().counter() : type;
    }

    public DataType fromJava(Object value) {
        return DataType.fromJava((Object)value);
    }

    public boolean isUnsupported(DataType type) {
        return type == DataType.UNSUPPORTED;
    }

    public boolean canConvert(DataType from, DataType to) {
        return EsqlDataTypeConverter.canConvert(from, to);
    }

    public Object convert(Object value, DataType type) {
        return EsqlDataTypeConverter.convert(value, type);
    }

    public DataType commonType(DataType left, DataType right) {
        if (EsqlDataTypes.isDateTimeOrTemporal(left) || EsqlDataTypes.isDateTimeOrTemporal(right)) {
            if (DataType.isDateTime((DataType)left) && EsqlDataTypes.isNullOrTemporalAmount(right) || EsqlDataTypes.isNullOrTemporalAmount(left) && DataType.isDateTime((DataType)right)) {
                return DataType.DATETIME;
            }
            if (EsqlDataTypes.isNullOrTimeDuration(left) && EsqlDataTypes.isNullOrTimeDuration(right)) {
                return DataType.TIME_DURATION;
            }
            if (EsqlDataTypes.isNullOrDatePeriod(left) && EsqlDataTypes.isNullOrDatePeriod(right)) {
                return DataType.DATE_PERIOD;
            }
        }
        return EsqlDataTypeConverter.commonType(left, right);
    }
}

