/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.Converter;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetime;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIP;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersion;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.versionfield.Version;

public class EsqlDataTypeConverter {
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"strict_date_optional_time");
    public static final DateFormatter HOUR_MINUTE_SECOND = DateFormatter.forPattern((String)"strict_hour_minute_second_fraction");
    private static final Map<DataType, BiFunction<Source, Expression, AbstractConvertFunction>> TYPE_TO_CONVERTER_FUNCTION = Map.ofEntries(Map.entry(DataType.BOOLEAN, ToBoolean::new), Map.entry(DataType.CARTESIAN_POINT, ToCartesianPoint::new), Map.entry(DataType.CARTESIAN_SHAPE, ToCartesianShape::new), Map.entry(DataType.DATETIME, ToDatetime::new), Map.entry(DataType.DOUBLE, ToDouble::new), Map.entry(DataType.GEO_POINT, ToGeoPoint::new), Map.entry(DataType.GEO_SHAPE, ToGeoShape::new), Map.entry(DataType.INTEGER, ToInteger::new), Map.entry(DataType.IP, ToIP::new), Map.entry(DataType.LONG, ToLong::new), Map.entry(DataType.KEYWORD, ToString::new), Map.entry(DataType.TEXT, ToString::new), Map.entry(DataType.UNSIGNED_LONG, ToUnsignedLong::new), Map.entry(DataType.VERSION, ToVersion::new));

    public static boolean canConvert(DataType from, DataType to) {
        if (from == to || from == DataType.NULL) {
            return true;
        }
        return DataType.isPrimitive((DataType)from) && DataType.isPrimitive((DataType)to) && EsqlDataTypeConverter.converterFor(from, to) != null;
    }

    public static Converter converterFor(DataType from, DataType to) {
        Converter converter;
        if (DataType.isString((DataType)from)) {
            if (to == DataType.DATETIME) {
                return EsqlConverter.STRING_TO_DATETIME;
            }
            if (to == DataType.IP) {
                return EsqlConverter.STRING_TO_IP;
            }
            if (to == DataType.VERSION) {
                return EsqlConverter.STRING_TO_VERSION;
            }
            if (to == DataType.DOUBLE) {
                return EsqlConverter.STRING_TO_DOUBLE;
            }
            if (to == DataType.LONG) {
                return EsqlConverter.STRING_TO_LONG;
            }
            if (to == DataType.INTEGER) {
                return EsqlConverter.STRING_TO_INT;
            }
            if (to == DataType.BOOLEAN) {
                return EsqlConverter.STRING_TO_BOOLEAN;
            }
            if (EsqlDataTypes.isSpatial(to)) {
                return EsqlConverter.STRING_TO_SPATIAL;
            }
            if (to == DataType.TIME_DURATION) {
                return EsqlConverter.STRING_TO_TIME_DURATION;
            }
            if (to == DataType.DATE_PERIOD) {
                return EsqlConverter.STRING_TO_DATE_PERIOD;
            }
        }
        if ((converter = DataTypeConverter.converterFor((DataType)from, (DataType)to)) != null) {
            return converter;
        }
        return null;
    }

    public static TemporalAmount parseTemporalAmount(Object val, DataType expectedType) {
        Object errorMessage = "Cannot parse [{}] to {}";
        String str = String.valueOf(val);
        if (str == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        StringBuilder qualifier = new StringBuilder();
        StringBuilder nextBuffer = value;
        boolean lastWasSpace = false;
        for (char c : str.trim().toCharArray()) {
            if (c == ' ') {
                if (!lastWasSpace) {
                    nextBuffer = nextBuffer == value ? qualifier : null;
                }
                lastWasSpace = true;
                continue;
            }
            if (nextBuffer == null) {
                throw new ParsingException(Source.EMPTY, (String)errorMessage, val, expectedType);
            }
            nextBuffer.append(c);
            lastWasSpace = false;
        }
        if (!(value.isEmpty() || qualifier.isEmpty())) {
            try {
                TemporalAmount result = EsqlDataTypeConverter.parseTemporalAmout(Integer.parseInt(value.toString()), qualifier.toString(), Source.EMPTY);
                if (DataType.DATE_PERIOD == expectedType && result instanceof Period || DataType.TIME_DURATION == expectedType && result instanceof Duration) {
                    return result;
                }
                if (result instanceof Period && expectedType == DataType.TIME_DURATION) {
                    errorMessage = (String)errorMessage + ", did you mean " + DataType.DATE_PERIOD + "?";
                }
                if (result instanceof Duration && expectedType == DataType.DATE_PERIOD) {
                    errorMessage = (String)errorMessage + ", did you mean " + DataType.TIME_DURATION + "?";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParsingException(Source.EMPTY, (String)errorMessage, val, expectedType);
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = DataType.fromJava((Object)value);
        if (detectedType == dataType || value == null) {
            return value;
        }
        Converter converter = EsqlDataTypeConverter.converterFor(detectedType, dataType);
        if (converter == null) {
            throw new QlIllegalArgumentException("cannot convert from [{}], type [{}] to [{}]", new Object[]{value, detectedType.typeName(), dataType.typeName()});
        }
        return converter.convert(value);
    }

    public static DataType commonType(DataType left, DataType right) {
        return DataTypeConverter.commonType((DataType)left, (DataType)right);
    }

    public static TemporalAmount parseTemporalAmout(Number value, String qualifier, Source source) throws InvalidArgumentException, ArithmeticException, ParsingException {
        return switch (qualifier) {
            case "millisecond", "milliseconds", "ms" -> Duration.ofMillis(DataTypeConverter.safeToLong((Number)value));
            case "second", "seconds", "sec", "s" -> Duration.ofSeconds(DataTypeConverter.safeToLong((Number)value));
            case "minute", "minutes", "min" -> Duration.ofMinutes(DataTypeConverter.safeToLong((Number)value));
            case "hour", "hours", "h" -> Duration.ofHours(DataTypeConverter.safeToLong((Number)value));
            case "day", "days", "d" -> Period.ofDays(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "week", "weeks", "w" -> Period.ofWeeks(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "month", "months", "mo" -> Period.ofMonths(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            case "quarter", "quarters", "q" -> Period.ofMonths(DataTypeConverter.safeToInt((long)Math.multiplyExact(3L, DataTypeConverter.safeToLong((Number)value))));
            case "year", "years", "yr", "y" -> Period.ofYears(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            default -> throw new ParsingException(source, "Unexpected time interval qualifier: '{}'", qualifier);
        };
    }

    private static ChronoField stringToChrono(Object field) {
        ChronoField chronoField = null;
        try {
            BytesRef br = BytesRefs.toBytesRef((Object)field);
            chronoField = ChronoField.valueOf(br.utf8ToString().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            return null;
        }
        return chronoField;
    }

    public static long chronoToLong(long dateTime, BytesRef chronoField, ZoneId zone) {
        ChronoField chrono = ChronoField.valueOf(chronoField.utf8ToString().toUpperCase(Locale.ROOT));
        return Instant.ofEpochMilli(dateTime).atZone(zone).getLong(chrono);
    }

    public static long chronoToLong(long dateTime, ChronoField chronoField, ZoneId zone) {
        return Instant.ofEpochMilli(dateTime).atZone(zone).getLong(chronoField);
    }

    public static BytesRef stringToIP(BytesRef field) {
        return StringUtils.parseIP((String)field.utf8ToString());
    }

    public static BytesRef stringToIP(String field) {
        return StringUtils.parseIP((String)field);
    }

    public static String ipToString(BytesRef field) {
        return DocValueFormat.IP.format(field);
    }

    public static BytesRef stringToVersion(BytesRef field) {
        return new Version(field.utf8ToString()).toBytesRef();
    }

    public static BytesRef stringToVersion(String field) {
        return new Version(field).toBytesRef();
    }

    public static String versionToString(BytesRef field) {
        return new Version(field).toString();
    }

    public static String versionToString(Version field) {
        return field.toString();
    }

    public static String spatialToString(BytesRef field) {
        return SpatialCoordinateTypes.UNSPECIFIED.wkbToWkt(field);
    }

    public static BytesRef stringToSpatial(String field) {
        return SpatialCoordinateTypes.UNSPECIFIED.wktToWkb(field);
    }

    public static long dateTimeToLong(String dateTime) {
        return DEFAULT_DATE_TIME_FORMATTER.parseMillis(dateTime);
    }

    public static long dateTimeToLong(String dateTime, DateFormatter formatter) {
        return formatter == null ? EsqlDataTypeConverter.dateTimeToLong(dateTime) : formatter.parseMillis(dateTime);
    }

    public static String dateTimeToString(long dateTime) {
        return DEFAULT_DATE_TIME_FORMATTER.formatMillis(dateTime);
    }

    public static String dateTimeToString(long dateTime, DateFormatter formatter) {
        return formatter == null ? EsqlDataTypeConverter.dateTimeToString(dateTime) : formatter.formatMillis(dateTime);
    }

    public static BytesRef numericBooleanToString(Object field) {
        return new BytesRef((CharSequence)String.valueOf(field));
    }

    public static boolean stringToBoolean(String field) {
        return Boolean.parseBoolean(field);
    }

    public static int stringToInt(String field) {
        try {
            return Integer.parseInt(field);
        }
        catch (NumberFormatException nfe) {
            try {
                return DataTypeConverter.safeToInt((double)EsqlDataTypeConverter.stringToDouble(field));
            }
            catch (Exception e) {
                throw new InvalidArgumentException((Throwable)nfe, "Cannot parse number [{}]", new Object[]{field});
            }
        }
    }

    public static long stringToLong(String field) {
        try {
            return StringUtils.parseLong((String)field);
        }
        catch (InvalidArgumentException iae) {
            try {
                return DataTypeConverter.safeDoubleToLong((double)EsqlDataTypeConverter.stringToDouble(field));
            }
            catch (Exception e) {
                throw new InvalidArgumentException((Throwable)iae, "Cannot parse number [{}]", new Object[]{field});
            }
        }
    }

    public static double stringToDouble(String field) {
        return StringUtils.parseDouble((String)field);
    }

    public static BytesRef unsignedLongToString(long number) {
        return new BytesRef((CharSequence)NumericUtils.unsignedLongAsNumber((long)number).toString());
    }

    public static long stringToUnsignedLong(String field) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((String)field));
    }

    public static Number stringToIntegral(String field) {
        return StringUtils.parseIntegral((String)field);
    }

    public static double unsignedLongToDouble(long number) {
        return NumericUtils.unsignedLongAsNumber((long)number).doubleValue();
    }

    public static long doubleToUnsignedLong(double number) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Double)number));
    }

    public static int unsignedLongToInt(long number) {
        Number n = NumericUtils.unsignedLongAsNumber((long)number);
        int i = n.intValue();
        if ((long)i != n.longValue()) {
            throw new InvalidArgumentException("[{}] out of [integer] range", new Object[]{n});
        }
        return i;
    }

    public static long intToUnsignedLong(int number) {
        return EsqlDataTypeConverter.longToUnsignedLong(number, false);
    }

    public static long unsignedLongToLong(long number) {
        return DataTypeConverter.safeToLong((Number)NumericUtils.unsignedLongAsNumber((long)number));
    }

    public static long longToUnsignedLong(long number, boolean allowNegative) {
        return !allowNegative ? NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Long)number)) : NumericUtils.asLongUnsigned((long)number);
    }

    public static long bigIntegerToUnsignedLong(BigInteger field) {
        BigInteger unsignedLong = NumericUtils.asUnsignedLong((BigInteger)field);
        return NumericUtils.asLongUnsigned((BigInteger)unsignedLong);
    }

    public static BigInteger unsignedLongToBigInteger(long number) {
        return NumericUtils.unsignedLongAsBigInteger((long)number);
    }

    public static boolean unsignedLongToBoolean(long number) {
        Number n = NumericUtils.unsignedLongAsNumber((long)number);
        return n instanceof BigInteger || n.longValue() != 0L;
    }

    public static long booleanToUnsignedLong(boolean number) {
        return number ? NumericUtils.ONE_AS_UNSIGNED_LONG : NumericUtils.ZERO_AS_UNSIGNED_LONG;
    }

    public static BiFunction<Source, Expression, AbstractConvertFunction> converterFunctionFactory(DataType toType) {
        return TYPE_TO_CONVERTER_FUNCTION.get(toType);
    }

    public static enum EsqlConverter implements Converter
    {
        STRING_TO_DATE_PERIOD(x -> EsqlDataTypeConverter.parseTemporalAmount(x, DataType.DATE_PERIOD)),
        STRING_TO_TIME_DURATION(x -> EsqlDataTypeConverter.parseTemporalAmount(x, DataType.TIME_DURATION)),
        STRING_TO_CHRONO_FIELD(EsqlDataTypeConverter::stringToChrono),
        STRING_TO_DATETIME(x -> EsqlDataTypeConverter.dateTimeToLong((String)x)),
        STRING_TO_IP(x -> EsqlDataTypeConverter.stringToIP((String)x)),
        STRING_TO_VERSION(x -> EsqlDataTypeConverter.stringToVersion((String)x)),
        STRING_TO_DOUBLE(x -> EsqlDataTypeConverter.stringToDouble((String)x)),
        STRING_TO_LONG(x -> EsqlDataTypeConverter.stringToLong((String)x)),
        STRING_TO_INT(x -> EsqlDataTypeConverter.stringToInt((String)x)),
        STRING_TO_BOOLEAN(x -> EsqlDataTypeConverter.stringToBoolean((String)x)),
        STRING_TO_SPATIAL(x -> EsqlDataTypeConverter.stringToSpatial((String)x));

        private static final String NAME = "esql-converter";
        private final Function<Object, Object> converter;

        private EsqlConverter(Function<Object, Object> converter) {
            this.converter = converter;
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Converter read(StreamInput in) throws IOException {
            return (Converter)in.readEnum(EsqlConverter.class);
        }

        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }
    }
}

