/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.analysis.AnalyzerContext;
import org.elasticsearch.xpack.esql.analysis.EnrichResolution;
import org.elasticsearch.xpack.esql.analysis.PreAnalyzer;
import org.elasticsearch.xpack.esql.analysis.Verifier;
import org.elasticsearch.xpack.esql.core.analyzer.TableInfo;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedStar;
import org.elasticsearch.xpack.esql.core.index.IndexResolution;
import org.elasticsearch.xpack.esql.core.index.MappingException;
import org.elasticsearch.xpack.esql.core.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.type.InvalidMappedField;
import org.elasticsearch.xpack.esql.core.util.ActionListeners;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.enrich.ResolvedEnrichPolicy;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.parser.EsqlParser;
import org.elasticsearch.xpack.esql.parser.QueryParams;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.session.IndexResolver;

public class EsqlSession {
    private static final Logger LOGGER = LogManager.getLogger(EsqlSession.class);
    private final String sessionId;
    private final EsqlConfiguration configuration;
    private final IndexResolver indexResolver;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final PreAnalyzer preAnalyzer;
    private final Verifier verifier;
    private final EsqlFunctionRegistry functionRegistry;
    private final LogicalPlanOptimizer logicalPlanOptimizer;
    private final Mapper mapper;
    private final PhysicalPlanOptimizer physicalPlanOptimizer;

    public EsqlSession(String sessionId, EsqlConfiguration configuration, IndexResolver indexResolver, EnrichPolicyResolver enrichPolicyResolver, PreAnalyzer preAnalyzer, EsqlFunctionRegistry functionRegistry, LogicalPlanOptimizer logicalPlanOptimizer, Mapper mapper, Verifier verifier) {
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.indexResolver = indexResolver;
        this.enrichPolicyResolver = enrichPolicyResolver;
        this.preAnalyzer = preAnalyzer;
        this.verifier = verifier;
        this.functionRegistry = functionRegistry;
        this.mapper = mapper;
        this.logicalPlanOptimizer = logicalPlanOptimizer;
        this.physicalPlanOptimizer = new PhysicalPlanOptimizer(new PhysicalOptimizerContext(configuration));
    }

    public String sessionId() {
        return this.sessionId;
    }

    public void execute(EsqlQueryRequest request, ActionListener<PhysicalPlan> listener) {
        LOGGER.debug("ESQL query:\n{}", new Object[]{request.query()});
        this.optimizedPhysicalPlan(this.parse(request.query(), request.params()), (ActionListener<PhysicalPlan>)listener.map(plan -> EstimatesRowSize.estimateRowSize(0, (PhysicalPlan)plan.transformUp(FragmentExec.class, f -> {
            QueryBuilder filter = request.filter();
            if (filter != null) {
                QueryBuilder fragmentFilter = f.esFilter();
                filter = fragmentFilter != null ? QueryBuilders.boolQuery().filter(fragmentFilter).must(filter) : filter;
                LOGGER.debug("Fold filter {} to EsQueryExec", new Object[]{filter});
                f = f.withFilter(filter);
            }
            return f;
        }))));
    }

    private LogicalPlan parse(String query, QueryParams params) {
        LogicalPlan parsed = new EsqlParser().createStatement(query, params);
        LOGGER.debug("Parsed logical plan:\n{}", new Object[]{parsed});
        return parsed;
    }

    public void analyzedPlan(LogicalPlan parsed, ActionListener<LogicalPlan> listener) {
        if (parsed.analyzed()) {
            listener.onResponse((Object)parsed);
            return;
        }
        this.preAnalyze(parsed, (indices, policies) -> {
            Analyzer analyzer = new Analyzer(new AnalyzerContext(this.configuration, this.functionRegistry, (IndexResolution)indices, (EnrichResolution)policies), this.verifier);
            LogicalPlan plan = analyzer.analyze(parsed);
            LOGGER.debug("Analyzed plan:\n{}", new Object[]{plan});
            return plan;
        }, listener);
    }

    private <T> void preAnalyze(LogicalPlan parsed, BiFunction<IndexResolution, EnrichResolution, T> action, ActionListener<T> listener) {
        PreAnalyzer.PreAnalysis preAnalysis = this.preAnalyzer.preAnalyze(parsed);
        Set<EnrichPolicyResolver.UnresolvedPolicy> unresolvedPolicies = preAnalysis.enriches.stream().map(e -> new EnrichPolicyResolver.UnresolvedPolicy((String)e.policyName().fold(), e.mode())).collect(Collectors.toSet());
        Set<String> targetClusters = this.enrichPolicyResolver.groupIndicesPerCluster((String[])preAnalysis.indices.stream().flatMap(t -> Arrays.stream(Strings.commaDelimitedListToStringArray((String)t.id().index()))).toArray(String[]::new)).keySet();
        this.enrichPolicyResolver.resolvePolicies(targetClusters, unresolvedPolicies, (ActionListener<EnrichResolution>)listener.delegateFailureAndWrap((l, enrichResolution) -> {
            Set<String> matchFields = enrichResolution.resolvedEnrichPolicies().stream().map(ResolvedEnrichPolicy::matchField).collect(Collectors.toSet());
            this.preAnalyzeIndices(parsed, (ActionListener<IndexResolution>)l.delegateFailureAndWrap((ll, indexResolution) -> {
                Set<String> newClusters;
                if (indexResolution.isValid() && !targetClusters.containsAll(newClusters = this.enrichPolicyResolver.groupIndicesPerCluster((String[])indexResolution.get().concreteIndices().toArray(String[]::new)).keySet())) {
                    this.enrichPolicyResolver.resolvePolicies(newClusters, unresolvedPolicies, (ActionListener<EnrichResolution>)ll.map(newEnrichResolution -> action.apply((IndexResolution)indexResolution, (EnrichResolution)newEnrichResolution)));
                    return;
                }
                ll.onResponse(action.apply((IndexResolution)indexResolution, (EnrichResolution)enrichResolution));
            }), matchFields);
        }));
    }

    private <T> void preAnalyzeIndices(LogicalPlan parsed, ActionListener<IndexResolution> listener, Set<String> enrichPolicyMatchFields) {
        PreAnalyzer.PreAnalysis preAnalysis = new PreAnalyzer().preAnalyze(parsed);
        if (preAnalysis.indices.size() > 1) {
            listener.onFailure((Exception)new MappingException("Queries with multiple indices are not supported", new Object[0]));
        } else if (preAnalysis.indices.size() == 1) {
            TableInfo tableInfo = preAnalysis.indices.get(0);
            TableIdentifier table = tableInfo.id();
            Set<String> fieldNames = EsqlSession.fieldNames(parsed, enrichPolicyMatchFields);
            this.indexResolver.resolveAsMergedMapping(table.index(), fieldNames, listener);
        } else {
            try {
                listener.onResponse((Object)IndexResolution.invalid((String)"[none specified]"));
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }
    }

    static Set<String> fieldNames(LogicalPlan parsed, Set<String> enrichPolicyMatchFields) {
        if (!parsed.anyMatch(plan -> plan instanceof Aggregate || plan instanceof Project)) {
            return IndexResolver.ALL_FIELDS;
        }
        Holder projectAll = new Holder((Object)false);
        parsed.forEachExpressionDown(UnresolvedStar.class, us -> {
            if (((Boolean)projectAll.get()).booleanValue()) {
                return;
            }
            projectAll.set((Object)true);
        });
        if (((Boolean)projectAll.get()).booleanValue()) {
            return IndexResolver.ALL_FIELDS;
        }
        AttributeSet references = new AttributeSet();
        AttributeSet keepCommandReferences = new AttributeSet();
        ArrayList keepMatches = new ArrayList();
        ArrayList keepPatterns = new ArrayList();
        parsed.forEachDown(p -> {
            if (p instanceof RegexExtract) {
                RegexExtract re = (RegexExtract)p;
                for (Attribute extracted : re.extractedFields()) {
                    references.removeIf(attr -> EsqlSession.matchByName(attr, extracted.qualifiedName(), false));
                }
                references.addAll(re.input().references());
            } else if (p instanceof Enrich) {
                AttributeSet enrichRefs = p.references();
                enrichRefs.removeIf(attr -> attr instanceof EmptyAttribute);
                references.addAll(enrichRefs);
            } else {
                references.addAll(p.references());
                p.forEachExpression(UnresolvedNamePattern.class, up -> {
                    UnresolvedAttribute ua = new UnresolvedAttribute(up.source(), up.name());
                    references.add((Attribute)ua);
                    if (p instanceof Keep) {
                        keepCommandReferences.add((Attribute)ua);
                        keepMatches.add(up::match);
                    }
                });
                if (p instanceof Keep) {
                    keepCommandReferences.addAll(p.references());
                }
            }
            p.forEachExpressionDown(Alias.class, alias -> {
                if (p.references().names().contains(alias.qualifiedName())) {
                    return;
                }
                references.removeIf(attr -> EsqlSession.matchByName(attr, alias.qualifiedName(), keepCommandReferences.contains(attr)));
            });
        });
        references.removeIf(a -> a instanceof MetadataAttribute || MetadataAttribute.isSupported((String)a.qualifiedName()));
        Set fieldNames = references.names();
        if (fieldNames.isEmpty() && enrichPolicyMatchFields.isEmpty()) {
            return IndexResolver.INDEX_METADATA_FIELD;
        }
        fieldNames.addAll(EsqlSession.subfields(fieldNames));
        fieldNames.addAll(enrichPolicyMatchFields);
        fieldNames.addAll(EsqlSession.subfields(enrichPolicyMatchFields));
        return fieldNames;
    }

    private static boolean matchByName(Attribute attr, String other, boolean skipIfPattern) {
        boolean isPattern = Regex.isSimpleMatchPattern((String)attr.qualifiedName());
        if (skipIfPattern && isPattern) {
            return false;
        }
        String name = attr.qualifiedName();
        return isPattern ? Regex.simpleMatch((String)name, (String)other) : name.equals(other);
    }

    private static Set<String> subfields(Set<String> names) {
        return names.stream().filter(name -> !name.endsWith("*")).map(name -> name + ".*").collect(Collectors.toSet());
    }

    public void optimizedPlan(LogicalPlan logicalPlan, ActionListener<LogicalPlan> listener) {
        this.analyzedPlan(logicalPlan, (ActionListener<LogicalPlan>)ActionListeners.map(listener, p -> {
            LogicalPlan plan = this.logicalPlanOptimizer.optimize((LogicalPlan)p);
            LOGGER.debug("Optimized logicalPlan plan:\n{}", new Object[]{plan});
            return plan;
        }));
    }

    public void physicalPlan(LogicalPlan optimized, ActionListener<PhysicalPlan> listener) {
        this.optimizedPlan(optimized, (ActionListener<LogicalPlan>)ActionListeners.map(listener, p -> {
            PhysicalPlan plan = this.mapper.map((LogicalPlan)p);
            LOGGER.debug("Physical plan:\n{}", new Object[]{plan});
            return plan;
        }));
    }

    public void optimizedPhysicalPlan(LogicalPlan logicalPlan, ActionListener<PhysicalPlan> listener) {
        this.physicalPlan(logicalPlan, (ActionListener<PhysicalPlan>)ActionListeners.map(listener, p -> {
            PhysicalPlan plan = this.physicalPlanOptimizer.optimize((PhysicalPlan)((Object)p));
            LOGGER.debug("Optimized physical plan:\n{}", new Object[]{plan});
            return plan;
        }));
    }

    public static InvalidMappedField specificValidity(String fieldName, Map<String, FieldCapabilities> types) {
        boolean hasUnmapped = types.containsKey("unmapped");
        boolean hasTypeConflicts = types.size() > (hasUnmapped ? 2 : 1);
        String metricConflictsTypeName = null;
        boolean hasMetricConflicts = false;
        if (!hasTypeConflicts) {
            for (Map.Entry<String, FieldCapabilities> type : types.entrySet()) {
                if ("unmapped".equals(type.getKey()) || type.getValue().metricConflictsIndices() == null || type.getValue().metricConflictsIndices().length <= 0) continue;
                hasMetricConflicts = true;
                metricConflictsTypeName = type.getKey();
                break;
            }
        }
        InvalidMappedField result = null;
        if (hasMetricConflicts) {
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append("mapped as different metric types in indices: [" + String.join((CharSequence)", ", types.get(metricConflictsTypeName).metricConflictsIndices()) + "]");
            result = new InvalidMappedField(fieldName, errorMessage.toString());
        }
        return result;
    }
}

