/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverTaskRunner;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.ClusterComputeRequest;
import org.elasticsearch.xpack.esql.plugin.ComputeListener;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.DataNodeRequest;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

public class ComputeService {
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final SearchService searchService;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final TransportService transportService;
    private final Executor esqlExecutor;
    private final DriverTaskRunner driverRunner;
    private final ExchangeService exchangeService;
    private final EnrichLookupService enrichLookupService;
    private final ClusterService clusterService;
    public static final String DATA_ACTION_NAME = "indices:data/read/esql/data";
    public static final String CLUSTER_ACTION_NAME = "indices:data/read/esql/cluster";

    public ComputeService(SearchService searchService, TransportService transportService, ExchangeService exchangeService, EnrichLookupService enrichLookupService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory) {
        this.searchService = searchService;
        this.transportService = transportService;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.blockFactory = blockFactory;
        this.esqlExecutor = threadPool.executor("search");
        transportService.registerRequestHandler(DATA_ACTION_NAME, this.esqlExecutor, DataNodeRequest::new, (TransportRequestHandler)new DataNodeRequestHandler());
        transportService.registerRequestHandler(CLUSTER_ACTION_NAME, this.esqlExecutor, ClusterComputeRequest::new, (TransportRequestHandler)new ClusterRequestHandler());
        this.driverRunner = new DriverTaskRunner(transportService, this.esqlExecutor);
        this.exchangeService = exchangeService;
        this.enrichLookupService = enrichLookupService;
        this.clusterService = clusterService;
    }

    public void execute(String sessionId, CancellableTask rootTask, PhysicalPlan physicalPlan, EsqlConfiguration configuration, ActionListener<Result> listener) {
        Tuple<PhysicalPlan, PhysicalPlan> coordinatorAndDataNodePlan = PlannerUtils.breakPlanBetweenCoordinatorAndDataNode(physicalPlan, configuration);
        List collectedPages = Collections.synchronizedList(new ArrayList());
        listener = listener.delegateResponse((l, e) -> {
            collectedPages.forEach(p -> Releasables.closeExpectNoException(() -> ((Page)p).releaseBlocks()));
            l.onFailure(e);
        });
        OutputExec coordinatorPlan = new OutputExec((PhysicalPlan)((Object)coordinatorAndDataNodePlan.v1()), collectedPages::add);
        PhysicalPlan dataNodePlan = (PhysicalPlan)((Object)coordinatorAndDataNodePlan.v2());
        if (dataNodePlan != null && !(dataNodePlan instanceof ExchangeSinkExec)) {
            assert (false) : "expected data node plan starts with an ExchangeSink; got " + dataNodePlan;
            listener.onFailure((Exception)new IllegalStateException("expected data node plan starts with an ExchangeSink; got " + dataNodePlan));
            return;
        }
        Map clusterToConcreteIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, (String[])PlannerUtils.planConcreteIndices(physicalPlan).toArray(String[]::new));
        QueryPragmas queryPragmas = configuration.pragmas();
        if (dataNodePlan == null) {
            if (!clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
                String error = "expected no concrete indices without data node plan; got " + clusterToConcreteIndices;
                assert (false) : error;
                listener.onFailure((Exception)new IllegalStateException(error));
                return;
            }
            ComputeContext computeContext = new ComputeContext(sessionId, "", List.of(), configuration, null, null);
            try (ComputeListener computeListener = new ComputeListener(this.transportService, rootTask, (ActionListener<ComputeResponse>)listener.map(r -> new Result(collectedPages, r.getProfiles())));){
                this.runCompute(rootTask, computeContext, coordinatorPlan, computeListener.acquireCompute());
                return;
            }
        }
        if (clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
            String error = "expected concrete indices with data node plan but got empty; data node plan " + dataNodePlan;
            assert (false) : error;
            listener.onFailure((Exception)new IllegalStateException(error));
            return;
        }
        Map clusterToOriginalIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, PlannerUtils.planOriginalIndices(physicalPlan));
        OriginalIndices localOriginalIndices = (OriginalIndices)clusterToOriginalIndices.remove("");
        OriginalIndices localConcreteIndices = (OriginalIndices)clusterToConcreteIndices.remove("");
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(queryPragmas.exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        try (Releasable ignored = exchangeSource.addEmptySink();
             ComputeListener computeListener = new ComputeListener(this.transportService, rootTask, (ActionListener<ComputeResponse>)listener.map(r -> new Result(collectedPages, r.getProfiles())));){
            exchangeSource.addCompletionListener(computeListener.acquireAvoid());
            this.runCompute(rootTask, new ComputeContext(sessionId, "", List.of(), configuration, exchangeSource, null), coordinatorPlan, computeListener.acquireCompute());
            if (localConcreteIndices != null && localConcreteIndices.indices().length > 0) {
                this.startComputeOnDataNodes(sessionId, "", rootTask, configuration, dataNodePlan, Set.of(localConcreteIndices.indices()), localOriginalIndices.indices(), exchangeSource, computeListener);
            }
            this.startComputeOnRemoteClusters(sessionId, rootTask, configuration, dataNodePlan, exchangeSource, this.getRemoteClusters(clusterToConcreteIndices, clusterToOriginalIndices), computeListener);
        }
    }

    private List<RemoteCluster> getRemoteClusters(Map<String, OriginalIndices> clusterToConcreteIndices, Map<String, OriginalIndices> clusterToOriginalIndices) {
        ArrayList<RemoteCluster> remoteClusters = new ArrayList<RemoteCluster>(clusterToConcreteIndices.size());
        RemoteClusterService remoteClusterService = this.transportService.getRemoteClusterService();
        for (Map.Entry<String, OriginalIndices> e : clusterToConcreteIndices.entrySet()) {
            String clusterAlias = e.getKey();
            OriginalIndices concreteIndices = clusterToConcreteIndices.get(clusterAlias);
            OriginalIndices originalIndices = clusterToOriginalIndices.get(clusterAlias);
            if (originalIndices == null) {
                assert (false) : "can't find original indices for cluster " + clusterAlias;
                throw new IllegalStateException("can't find original indices for cluster " + clusterAlias);
            }
            if (concreteIndices.indices().length <= 0) continue;
            Transport.Connection connection = remoteClusterService.getConnection(clusterAlias);
            remoteClusters.add(new RemoteCluster(clusterAlias, connection, concreteIndices.indices(), originalIndices.indices()));
        }
        return remoteClusters;
    }

    private void startComputeOnDataNodes(String sessionId, String clusterAlias, CancellableTask parentTask, EsqlConfiguration configuration, PhysicalPlan dataNodePlan, Set<String> concreteIndices, String[] originalIndices, ExchangeSourceHandler exchangeSource, ComputeListener computeListener) {
        PhysicalPlan planWithReducer = !configuration.pragmas().nodeLevelReduction() ? dataNodePlan : (PhysicalPlan)dataNodePlan.transformUp(FragmentExec.class, f -> {
            PhysicalPlan reductionNode = PlannerUtils.dataNodeReductionPlan(f.fragment(), dataNodePlan);
            return reductionNode == null ? f : f.withReducer(reductionNode);
        });
        QueryBuilder requestFilter = PlannerUtils.requestFilter(planWithReducer, x -> true);
        ActionListener lookupListener = ActionListener.releaseAfter(computeListener.acquireAvoid(), (Releasable)exchangeSource.addEmptySink());
        this.lookupDataNodes((Task)parentTask, clusterAlias, requestFilter, concreteIndices, originalIndices, (ActionListener<List<DataNode>>)ActionListener.wrap(dataNodes -> {
            try (RefCountingListener refs = new RefCountingListener(lookupListener);){
                for (DataNode node : dataNodes) {
                    QueryPragmas queryPragmas = configuration.pragmas();
                    ExchangeService.openExchange((TransportService)this.transportService, (Transport.Connection)node.connection, (String)sessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)this.esqlExecutor, (ActionListener)refs.acquire().delegateFailureAndWrap((l, unused) -> {
                        RemoteSink remoteSink = this.exchangeService.newRemoteSink((Task)parentTask, sessionId, this.transportService, node.connection);
                        exchangeSource.addRemoteSink(remoteSink, queryPragmas.concurrentExchangeClients());
                        ActionListener dataNodeListener = ActionListener.runBefore(computeListener.acquireCompute(), () -> l.onResponse(null));
                        this.transportService.sendChildRequest(node.connection, DATA_ACTION_NAME, (TransportRequest)new DataNodeRequest(sessionId, configuration, clusterAlias, node.shardIds, node.aliasFilters, planWithReducer), (Task)parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(dataNodeListener, ComputeResponse::new, this.esqlExecutor));
                    }));
                }
            }
        }, arg_0 -> ((ActionListener)lookupListener).onFailure(arg_0)));
    }

    private void startComputeOnRemoteClusters(String sessionId, CancellableTask rootTask, EsqlConfiguration configuration, PhysicalPlan plan, ExchangeSourceHandler exchangeSource, List<RemoteCluster> clusters, ComputeListener computeListener) {
        QueryPragmas queryPragmas = configuration.pragmas();
        ActionListener linkExchangeListeners = ActionListener.releaseAfter(computeListener.acquireAvoid(), (Releasable)exchangeSource.addEmptySink());
        try (RefCountingListener refs = new RefCountingListener(linkExchangeListeners);){
            for (RemoteCluster cluster : clusters) {
                ExchangeService.openExchange((TransportService)this.transportService, (Transport.Connection)cluster.connection, (String)sessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)this.esqlExecutor, (ActionListener)refs.acquire().delegateFailureAndWrap((l, unused) -> {
                    RemoteSink remoteSink = this.exchangeService.newRemoteSink((Task)rootTask, sessionId, this.transportService, cluster.connection);
                    exchangeSource.addRemoteSink(remoteSink, queryPragmas.concurrentExchangeClients());
                    ClusterComputeRequest clusterRequest = new ClusterComputeRequest(cluster.clusterAlias, sessionId, configuration, plan, cluster.concreteIndices, cluster.originalIndices);
                    ActionListener clusterListener = ActionListener.runBefore(computeListener.acquireCompute(), () -> l.onResponse(null));
                    this.transportService.sendChildRequest(cluster.connection, CLUSTER_ACTION_NAME, (TransportRequest)clusterRequest, (Task)rootTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(clusterListener, ComputeResponse::new, this.esqlExecutor));
                }));
            }
        }
    }

    void runCompute(CancellableTask task, ComputeContext context, PhysicalPlan plan, ActionListener<ComputeResponse> listener) {
        List<Driver> drivers;
        listener = ActionListener.runBefore(listener, () -> Releasables.close(context.searchContexts));
        ArrayList<EsPhysicalOperationProviders.ShardContext> contexts = new ArrayList<EsPhysicalOperationProviders.ShardContext>(context.searchContexts.size());
        for (int i = 0; i < context.searchContexts.size(); ++i) {
            SearchContext searchContext = context.searchContexts.get(i);
            contexts.add(new EsPhysicalOperationProviders.DefaultShardContext(i, searchContext.getSearchExecutionContext(), searchContext.request().getAliasFilter()));
        }
        try {
            LocalExecutionPlanner planner = new LocalExecutionPlanner(context.sessionId, context.clusterAlias, task, this.bigArrays, this.blockFactory, this.clusterService.getSettings(), context.configuration, context.exchangeSource(), context.exchangeSink(), this.enrichLookupService, new EsPhysicalOperationProviders(contexts));
            LOGGER.debug("Received physical plan:\n{}", new Object[]{plan});
            plan = PlannerUtils.localPlan(context.searchExecutionContexts(), context.configuration, plan);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(plan);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Local execution plan:\n{}", new Object[]{localExecutionPlan.describe()});
            }
            if ((drivers = localExecutionPlan.createDrivers(context.sessionId)).isEmpty()) {
                throw new IllegalStateException("no drivers created");
            }
            LOGGER.debug("using {} drivers", new Object[]{drivers.size()});
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        ActionListener listenerCollectingStatus = listener.map(ignored -> {
            if (context.configuration.profile()) {
                return new ComputeResponse(drivers.stream().map(Driver::profile).toList());
            }
            return new ComputeResponse(List.of());
        });
        listenerCollectingStatus = ActionListener.releaseAfter((ActionListener)listenerCollectingStatus, () -> Releasables.close((Iterable)drivers));
        this.driverRunner.executeDrivers((Task)task, drivers, (Executor)this.transportService.getThreadPool().executor("esql_worker"), listenerCollectingStatus);
    }

    private void acquireSearchContexts(String clusterAlias, List<ShardId> shardIds, EsqlConfiguration configuration, Map<Index, AliasFilter> aliasFilters, ActionListener<List<SearchContext>> listener) {
        ArrayList<IndexShard> targetShards = new ArrayList<IndexShard>();
        try {
            for (ShardId shardId : shardIds) {
                IndexShard indexShard = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
                targetShards.add(indexShard);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        ActionRunnable doAcquire = ActionRunnable.supply(listener, () -> {
            ArrayList<SearchContext> searchContexts = new ArrayList<SearchContext>(targetShards.size());
            boolean success = false;
            try {
                for (IndexShard shard : targetShards) {
                    AliasFilter aliasFilter = aliasFilters.getOrDefault(shard.shardId().getIndex(), AliasFilter.EMPTY);
                    ShardSearchRequest shardRequest = new ShardSearchRequest(shard.shardId(), configuration.absoluteStartedTimeInMillis(), aliasFilter, clusterAlias);
                    SearchContext context = this.searchService.createSearchContext(shardRequest, SearchService.NO_TIMEOUT);
                    searchContexts.add(context);
                }
                for (SearchContext searchContext : searchContexts) {
                    searchContext.preProcess();
                }
                success = true;
                ArrayList<SearchContext> arrayList = searchContexts;
                return arrayList;
            }
            finally {
                if (!success) {
                    IOUtils.close(searchContexts);
                }
            }
        });
        AtomicBoolean waitedForRefreshes = new AtomicBoolean();
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            if (waitedForRefreshes.get()) {
                this.esqlExecutor.execute((Runnable)doAcquire);
            } else {
                doAcquire.run();
            }
        });){
            for (IndexShard targetShard : targetShards) {
                Releasable ref = refs.acquire();
                targetShard.ensureShardSearchActive(await -> {
                    try (Releasable releasable = ref;){
                        if (await.booleanValue()) {
                            waitedForRefreshes.set(true);
                        }
                    }
                });
            }
        }
    }

    private void lookupDataNodes(Task parentTask, String clusterAlias, QueryBuilder filter, Set<String> concreteIndices, String[] originalIndices, ActionListener<List<DataNode>> listener) {
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        ContextPreservingActionListener preservingContextListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)listener.map(resp -> {
            HashMap<String, DiscoveryNode> nodes = new HashMap<String, DiscoveryNode>();
            for (DiscoveryNode node : resp.getNodes()) {
                nodes.put(node.getId(), node);
            }
            HashMap<String, List> nodeToShards = new HashMap<String, List>();
            HashMap nodeToAliasFilters = new HashMap();
            for (SearchShardsGroup group : resp.getGroups()) {
                ShardId shardId = group.shardId();
                if (group.skipped()) continue;
                if (group.allocatedNodes().isEmpty()) {
                    throw new ShardNotFoundException(group.shardId(), "no shard copies found {}", new Object[]{group.shardId()});
                }
                if (!concreteIndices.contains(shardId.getIndexName())) continue;
                String targetNode = (String)group.allocatedNodes().get(0);
                nodeToShards.computeIfAbsent(targetNode, k -> new ArrayList()).add(shardId);
                AliasFilter aliasFilter = (AliasFilter)resp.getAliasFilters().get(shardId.getIndex().getUUID());
                if (aliasFilter == null) continue;
                nodeToAliasFilters.computeIfAbsent(targetNode, k -> new HashMap()).put(shardId.getIndex(), aliasFilter);
            }
            ArrayList<DataNode> dataNodes = new ArrayList<DataNode>(nodeToShards.size());
            for (Map.Entry e : nodeToShards.entrySet()) {
                DiscoveryNode node = (DiscoveryNode)nodes.get(e.getKey());
                Map<Index, AliasFilter> aliasFilters = nodeToAliasFilters.getOrDefault(e.getKey(), Map.of());
                dataNodes.add(new DataNode(this.transportService.getConnection(node), (List)e.getValue(), aliasFilters));
            }
            return dataNodes;
        }), (ThreadContext)threadContext);
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContextPreservingResponseHeaders();){
            threadContext.markAsSystemContext();
            SearchShardsRequest searchShardsRequest = new SearchShardsRequest(originalIndices, SearchRequest.DEFAULT_INDICES_OPTIONS, filter, null, null, false, clusterAlias);
            this.transportService.sendChildRequest(this.transportService.getLocalNode(), TransportSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)preservingContextListener, SearchShardsResponse::new, this.esqlExecutor));
        }
    }

    private void runComputeOnDataNode(CancellableTask task, String externalId, PhysicalPlan reducePlan, DataNodeRequest request, ComputeListener computeListener) {
        ActionListener<Void> parentListener = computeListener.acquireAvoid();
        try {
            ExchangeSinkHandler internalSink = this.exchangeService.createSinkHandler(request.sessionId(), request.pragmas().exchangeBufferSize());
            DataNodeRequestExecutor dataNodeRequestExecutor = new DataNodeRequestExecutor(request, task, internalSink, request.configuration().pragmas().maxConcurrentShardsPerNode(), computeListener);
            dataNodeRequestExecutor.start();
            ExchangeSinkHandler externalSink = this.exchangeService.getSinkHandler(externalId);
            task.addListener(() -> this.exchangeService.finishSinkHandler(externalId, (Exception)new TaskCancelledException(task.getReasonCancelled())));
            ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(1, this.esqlExecutor);
            exchangeSource.addCompletionListener(computeListener.acquireAvoid());
            exchangeSource.addRemoteSink((arg_0, arg_1) -> ((ExchangeSinkHandler)internalSink).fetchPageAsync(arg_0, arg_1), 1);
            ActionListener<ComputeResponse> reductionListener = computeListener.acquireCompute();
            this.runCompute(task, new ComputeContext(request.sessionId(), request.clusterAlias(), List.of(), request.configuration(), exchangeSource, externalSink), reducePlan, (ActionListener<ComputeResponse>)ActionListener.wrap(resp -> externalSink.addCompletionListener(ActionListener.running(() -> {
                this.exchangeService.finishSinkHandler(externalId, null);
                reductionListener.onResponse((Object)resp);
            })), e -> {
                this.exchangeService.finishSinkHandler(externalId, e);
                reductionListener.onFailure(e);
            }));
            parentListener.onResponse(null);
        }
        catch (Exception e2) {
            this.exchangeService.finishSinkHandler(externalId, e2);
            this.exchangeService.finishSinkHandler(request.sessionId(), e2);
            parentListener.onFailure(e2);
        }
    }

    void runComputeOnRemoteCluster(String clusterAlias, String globalSessionId, CancellableTask parentTask, EsqlConfiguration configuration, ExchangeSinkExec plan, Set<String> concreteIndices, String[] originalIndices, ComputeListener computeListener) {
        ExchangeSinkHandler exchangeSink = this.exchangeService.getSinkHandler(globalSessionId);
        parentTask.addListener(() -> this.exchangeService.finishSinkHandler(globalSessionId, (Exception)new TaskCancelledException(parentTask.getReasonCancelled())));
        String localSessionId = clusterAlias + ":" + globalSessionId;
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(configuration.pragmas().exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        try (Releasable ignored = exchangeSource.addEmptySink();){
            exchangeSink.addCompletionListener(computeListener.acquireAvoid());
            exchangeSource.addCompletionListener(computeListener.acquireAvoid());
            ExchangeSinkExec coordinatorPlan = new ExchangeSinkExec(plan.source(), plan.output(), plan.isIntermediateAgg(), new ExchangeSourceExec(plan.source(), plan.output(), plan.isIntermediateAgg()));
            this.runCompute(parentTask, new ComputeContext(localSessionId, clusterAlias, List.of(), configuration, exchangeSource, exchangeSink), coordinatorPlan, computeListener.acquireCompute());
            this.startComputeOnDataNodes(localSessionId, clusterAlias, parentTask, configuration, plan, concreteIndices, originalIndices, exchangeSource, computeListener);
        }
    }

    private class DataNodeRequestHandler
    implements TransportRequestHandler<DataNodeRequest> {
        private DataNodeRequestHandler() {
        }

        public void messageReceived(DataNodeRequest request, TransportChannel channel, Task task) {
            List fragments;
            ExchangeSinkExec plan;
            ChannelActionListener listener = new ChannelActionListener(channel);
            PhysicalPlan physicalPlan = request.plan();
            if (physicalPlan instanceof ExchangeSinkExec) {
                plan = (ExchangeSinkExec)physicalPlan;
                fragments = plan.collectFirstChildren(FragmentExec.class::isInstance);
                if (fragments.isEmpty()) {
                    listener.onFailure((Exception)new IllegalStateException("expected a fragment plan for a remote compute; got " + request.plan()));
                    return;
                }
            } else {
                listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + request.plan()));
                return;
            }
            ExchangeSourceExec localExchangeSource = new ExchangeSourceExec(plan.source(), plan.output(), plan.isIntermediateAgg());
            FragmentExec fragment = (FragmentExec)fragments.get(0);
            ExchangeSinkExec reducePlan = new ExchangeSinkExec(plan.source(), plan.output(), plan.isIntermediateAgg(), fragment.reducer() != null ? (PhysicalPlan)fragment.reducer().replaceChildren(List.of(localExchangeSource)) : localExchangeSource);
            String sessionId = request.sessionId();
            request = new DataNodeRequest(sessionId + "[n]", request.configuration(), request.clusterAlias(), request.shardIds(), request.aliasFilters(), request.plan());
            try (ComputeListener computeListener = new ComputeListener(ComputeService.this.transportService, (CancellableTask)task, (ActionListener<ComputeResponse>)listener);){
                ComputeService.this.runComputeOnDataNode((CancellableTask)task, sessionId, reducePlan, request, computeListener);
            }
        }
    }

    private class ClusterRequestHandler
    implements TransportRequestHandler<ClusterComputeRequest> {
        private ClusterRequestHandler() {
        }

        public void messageReceived(ClusterComputeRequest request, TransportChannel channel, Task task) {
            ChannelActionListener listener = new ChannelActionListener(channel);
            if (!(request.plan() instanceof ExchangeSinkExec)) {
                listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + request.plan()));
                return;
            }
            try (ComputeListener computeListener = new ComputeListener(ComputeService.this.transportService, (CancellableTask)task, (ActionListener<ComputeResponse>)listener);){
                ComputeService.this.runComputeOnRemoteCluster(request.clusterAlias(), request.sessionId(), (CancellableTask)task, request.configuration(), (ExchangeSinkExec)request.plan(), Set.of(request.indices()), request.originalIndices(), computeListener);
            }
        }
    }

    record ComputeContext(String sessionId, String clusterAlias, List<SearchContext> searchContexts, EsqlConfiguration configuration, ExchangeSourceHandler exchangeSource, ExchangeSinkHandler exchangeSink) {
        public List<SearchExecutionContext> searchExecutionContexts() {
            return this.searchContexts.stream().map(ctx -> ctx.getSearchExecutionContext()).toList();
        }
    }

    record RemoteCluster(String clusterAlias, Transport.Connection connection, String[] concreteIndices, String[] originalIndices) {
    }

    private class DataNodeRequestExecutor {
        private final DataNodeRequest request;
        private final CancellableTask parentTask;
        private final ExchangeSinkHandler exchangeSink;
        private final ComputeListener computeListener;
        private final int maxConcurrentShards;
        private final ExchangeSink blockingSink;

        DataNodeRequestExecutor(DataNodeRequest request, CancellableTask parentTask, ExchangeSinkHandler exchangeSink, int maxConcurrentShards, ComputeListener computeListener) {
            this.request = request;
            this.parentTask = parentTask;
            this.exchangeSink = exchangeSink;
            this.computeListener = computeListener;
            this.maxConcurrentShards = maxConcurrentShards;
            this.blockingSink = exchangeSink.createExchangeSink();
        }

        void start() {
            this.parentTask.addListener(() -> ComputeService.this.exchangeService.finishSinkHandler(this.request.sessionId(), (Exception)new TaskCancelledException(this.parentTask.getReasonCancelled())));
            this.runBatch(0);
        }

        private void runBatch(int startBatchIndex) {
            EsqlConfiguration configuration = this.request.configuration();
            String clusterAlias = this.request.clusterAlias();
            String sessionId = this.request.sessionId();
            final int endBatchIndex = Math.min(startBatchIndex + this.maxConcurrentShards, this.request.shardIds().size());
            List<ShardId> shardIds = this.request.shardIds().subList(startBatchIndex, endBatchIndex);
            ActionListener<ComputeResponse> batchListener = new ActionListener<ComputeResponse>(){
                final ActionListener<ComputeResponse> ref;
                {
                    this.ref = DataNodeRequestExecutor.this.computeListener.acquireCompute();
                }

                public void onResponse(ComputeResponse result) {
                    try {
                        DataNodeRequestExecutor.this.onBatchCompleted(endBatchIndex);
                    }
                    finally {
                        this.ref.onResponse((Object)result);
                    }
                }

                public void onFailure(Exception e) {
                    try {
                        ComputeService.this.exchangeService.finishSinkHandler(DataNodeRequestExecutor.this.request.sessionId(), e);
                    }
                    finally {
                        this.ref.onFailure(e);
                    }
                }
            };
            ComputeService.this.acquireSearchContexts(clusterAlias, shardIds, configuration, this.request.aliasFilters(), (ActionListener<List<SearchContext>>)ActionListener.wrap(arg_0 -> this.lambda$runBatch$1(sessionId, clusterAlias, configuration, (ActionListener)batchListener, arg_0), arg_0 -> ((ActionListener)batchListener).onFailure(arg_0)));
        }

        private void onBatchCompleted(int lastBatchIndex) {
            if (lastBatchIndex < this.request.shardIds().size() && !this.exchangeSink.isFinished()) {
                this.runBatch(lastBatchIndex);
            } else {
                ActionListener<Void> completionListener = this.computeListener.acquireAvoid();
                this.exchangeSink.addCompletionListener(ActionListener.runAfter(completionListener, () -> ComputeService.this.exchangeService.finishSinkHandler(this.request.sessionId(), null)));
                this.blockingSink.finish();
            }
        }

        private /* synthetic */ void lambda$runBatch$1(String sessionId, String clusterAlias, EsqlConfiguration configuration, ActionListener batchListener, List searchContexts) throws Exception {
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "esql_worker"}));
            ComputeContext computeContext = new ComputeContext(sessionId, clusterAlias, searchContexts, configuration, null, this.exchangeSink);
            ComputeService.this.runCompute(this.parentTask, computeContext, this.request.plan(), (ActionListener<ComputeResponse>)batchListener);
        }
    }

    record DataNode(Transport.Connection connection, List<ShardId> shardIds, Map<Index, AliasFilter> aliasFilters) {
    }

    public record Result(List<Page> pages, List<DriverProfile> profiles) {
    }
}

