/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.FailureCollector;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeService;

final class ComputeListener
implements Releasable {
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final RefCountingListener refs;
    private final FailureCollector failureCollector = new FailureCollector();
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final CancellableTask task;
    private final TransportService transportService;
    private final List<DriverProfile> collectedProfiles;
    private final ResponseHeadersCollector responseHeaders;

    ComputeListener(TransportService transportService, CancellableTask task, ActionListener<ComputeResponse> delegate) {
        this.transportService = transportService;
        this.task = task;
        this.responseHeaders = new ResponseHeadersCollector(transportService.getThreadPool().getThreadContext());
        this.collectedProfiles = Collections.synchronizedList(new ArrayList());
        this.refs = new RefCountingListener(1, ActionListener.wrap(ignored -> {
            this.responseHeaders.finish();
            ComputeResponse result = new ComputeResponse(this.collectedProfiles.isEmpty() ? List.of() : this.collectedProfiles.stream().toList());
            delegate.onResponse((Object)result);
        }, e -> delegate.onFailure(this.failureCollector.getFailure())));
    }

    ActionListener<Void> acquireAvoid() {
        return this.refs.acquire().delegateResponse((l, e) -> {
            this.failureCollector.unwrapAndCollect(e);
            try {
                if (this.cancelled.compareAndSet(false, true)) {
                    LOGGER.debug("cancelling ESQL task {} on failure", new Object[]{this.task});
                    this.transportService.getTaskManager().cancelTaskAndDescendants(this.task, "cancelled on failure", false, ActionListener.noop());
                }
            }
            finally {
                l.onFailure(e);
            }
        });
    }

    ActionListener<ComputeResponse> acquireCompute() {
        return this.acquireAvoid().map(resp -> {
            this.responseHeaders.collect();
            List<DriverProfile> profiles = resp.getProfiles();
            if (profiles != null && !profiles.isEmpty()) {
                this.collectedProfiles.addAll(profiles);
            }
            return null;
        });
    }

    public void close() {
        this.refs.close();
    }
}

