/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

final class ClusterComputeRequest
extends TransportRequest
implements IndicesRequest {
    private static final PlanNameRegistry planNameRegistry = new PlanNameRegistry();
    private final String clusterAlias;
    private final String sessionId;
    private final EsqlConfiguration configuration;
    private final PhysicalPlan plan;
    private final String[] originalIndices;
    private final String[] indices;

    ClusterComputeRequest(String clusterAlias, String sessionId, EsqlConfiguration configuration, PhysicalPlan plan, String[] indices, String[] originalIndices) {
        this.clusterAlias = clusterAlias;
        this.sessionId = sessionId;
        this.configuration = configuration;
        this.plan = plan;
        this.indices = indices;
        this.originalIndices = originalIndices;
    }

    ClusterComputeRequest(StreamInput in) throws IOException {
        super(in);
        this.clusterAlias = in.readString();
        this.sessionId = in.readString();
        this.configuration = new EsqlConfiguration(new BlockStreamInput(in, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE)));
        this.plan = new PlanStreamInput(in, planNameRegistry, in.namedWriteableRegistry(), this.configuration).readPhysicalPlanNode();
        this.indices = in.readStringArray();
        this.originalIndices = in.readStringArray();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.clusterAlias);
        out.writeString(this.sessionId);
        this.configuration.writeTo(out);
        new PlanStreamOutput(out, planNameRegistry, this.configuration).writePhysicalPlanNode(this.plan);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.originalIndices);
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        if (!parentTaskId.isSet()) {
            assert (false) : "DataNodeRequest must have a parent task";
            throw new IllegalStateException("DataNodeRequest must have a parent task");
        }
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            public String getDescription() {
                return ClusterComputeRequest.this.getDescription();
            }
        };
    }

    String clusterAlias() {
        return this.clusterAlias;
    }

    String sessionId() {
        return this.sessionId;
    }

    EsqlConfiguration configuration() {
        return this.configuration;
    }

    String[] originalIndices() {
        return this.originalIndices;
    }

    PhysicalPlan plan() {
        return this.plan;
    }

    public String getDescription() {
        return "indices=" + Arrays.toString(this.indices) + " plan=" + this.plan;
    }

    public String toString() {
        return "ClusterComputeRequest{" + this.getDescription() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ClusterComputeRequest request = (ClusterComputeRequest)((Object)o);
        return this.clusterAlias.equals(request.clusterAlias) && this.sessionId.equals(request.sessionId) && this.configuration.equals((Object)request.configuration) && Arrays.equals(this.indices, request.indices) && Arrays.equals(this.originalIndices, request.originalIndices) && this.plan.equals((Object)request.plan) && this.getParentTask().equals((Object)request.getParentTask());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sessionId, this.configuration, Arrays.hashCode(this.indices), Arrays.hashCode(this.originalIndices), this.plan});
    }
}

