/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.Limit;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.core.util.Queries;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.stats.SearchStats;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class PlannerUtils {
    @Deprecated(forRemoval=true)
    public static final BlockFactory NON_BREAKING_BLOCK_FACTORY = BlockFactory.getInstance((CircuitBreaker)new NoopCircuitBreaker("noop-esql-breaker"), (BigArrays)BigArrays.NON_RECYCLING_INSTANCE);

    public static Tuple<PhysicalPlan, PhysicalPlan> breakPlanBetweenCoordinatorAndDataNode(PhysicalPlan plan, EsqlConfiguration config) {
        Holder dataNodePlan = new Holder();
        PhysicalPlan coordinatorPlan = (PhysicalPlan)plan.transformUp(ExchangeExec.class, e -> {
            PhysicalPlan subplan = e.child();
            dataNodePlan.set((Object)new ExchangeSinkExec(e.source(), e.output(), e.isInBetweenAggs(), subplan));
            return new ExchangeSourceExec(e.source(), e.output(), e.isInBetweenAggs());
        });
        return new Tuple((Object)coordinatorPlan, (Object)((PhysicalPlan)((Object)dataNodePlan.get())));
    }

    public static PhysicalPlan dataNodeReductionPlan(LogicalPlan plan, PhysicalPlan unused) {
        List pipelineBreakers = plan.collectFirstChildren(Mapper::isPipelineBreaker);
        if (!pipelineBreakers.isEmpty()) {
            UnaryPlan pipelineBreaker = (UnaryPlan)pipelineBreakers.get(0);
            if (pipelineBreaker instanceof TopN) {
                Mapper mapper = new Mapper(true);
                PhysicalPlan physicalPlan = EstimatesRowSize.estimateRowSize(0, mapper.map(plan));
                return (PhysicalPlan)((Object)physicalPlan.collectFirstChildren(TopNExec.class::isInstance).get(0));
            }
            if (pipelineBreaker instanceof Limit) {
                Limit limit = (Limit)pipelineBreaker;
                return new LimitExec(limit.source(), unused, limit.limit());
            }
            if (pipelineBreaker instanceof OrderBy) {
                OrderBy order = (OrderBy)pipelineBreaker;
                return new OrderExec(order.source(), unused, order.order());
            }
            if (pipelineBreaker instanceof Aggregate) {
                Mapper mapper = new Mapper(true);
                PhysicalPlan physicalPlan = EstimatesRowSize.estimateRowSize(0, mapper.map(plan));
                AggregateExec aggregate = (AggregateExec)physicalPlan.collectFirstChildren(AggregateExec.class::isInstance).get(0);
                return aggregate.withMode(AggregateExec.Mode.PARTIAL);
            }
            throw new EsqlIllegalArgumentException("unsupported unary physical plan node [" + pipelineBreaker.nodeName() + "]");
        }
        return null;
    }

    public static Set<String> planConcreteIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Set.of();
        }
        LinkedHashSet<String> indices = new LinkedHashSet<String>();
        plan.forEachUp(FragmentExec.class, f -> f.fragment().forEachUp(EsRelation.class, r -> indices.addAll(r.index().concreteIndices())));
        return indices;
    }

    public static String[] planOriginalIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Strings.EMPTY_ARRAY;
        }
        LinkedHashSet indices = new LinkedHashSet();
        plan.forEachUp(FragmentExec.class, f -> f.fragment().forEachUp(EsRelation.class, r -> indices.addAll(Arrays.asList(Strings.commaDelimitedListToStringArray((String)r.index().name())))));
        return (String[])indices.toArray(String[]::new);
    }

    public static PhysicalPlan localPlan(List<SearchExecutionContext> searchContexts, EsqlConfiguration configuration, PhysicalPlan plan) {
        return PlannerUtils.localPlan(configuration, plan, new SearchStats(searchContexts));
    }

    public static PhysicalPlan localPlan(EsqlConfiguration configuration, PhysicalPlan plan, SearchStats searchStats) {
        LocalLogicalPlanOptimizer logicalOptimizer = new LocalLogicalPlanOptimizer(new LocalLogicalOptimizerContext(configuration, searchStats));
        LocalPhysicalPlanOptimizer physicalOptimizer = new LocalPhysicalPlanOptimizer(new LocalPhysicalOptimizerContext(configuration, searchStats));
        return PlannerUtils.localPlan(plan, logicalOptimizer, physicalOptimizer);
    }

    public static PhysicalPlan localPlan(PhysicalPlan plan, LocalLogicalPlanOptimizer logicalOptimizer, LocalPhysicalPlanOptimizer physicalOptimizer) {
        Mapper mapper = new Mapper(true);
        Holder isCoordPlan = new Holder((Object)Boolean.TRUE);
        PhysicalPlan localPhysicalPlan = (PhysicalPlan)plan.transformUp(FragmentExec.class, f -> {
            isCoordPlan.set((Object)Boolean.FALSE);
            LogicalPlan optimizedFragment = logicalOptimizer.localOptimize(f.fragment());
            PhysicalPlan physicalFragment = mapper.map(optimizedFragment);
            QueryBuilder filter = f.esFilter();
            if (filter != null) {
                physicalFragment = (PhysicalPlan)physicalFragment.transformUp(EsSourceExec.class, query -> new EsSourceExec(Source.EMPTY, query.index(), query.output(), filter, query.indexMode()));
            }
            PhysicalPlan localOptimized = physicalOptimizer.localOptimize(physicalFragment);
            return EstimatesRowSize.estimateRowSize(f.estimatedRowSize(), localOptimized);
        });
        return (Boolean)isCoordPlan.get() != false ? plan : localPhysicalPlan;
    }

    public static QueryBuilder requestFilter(PhysicalPlan plan, Predicate<FieldAttribute> hasIdenticalDelegate) {
        return PlannerUtils.detectFilter(plan, "@timestamp", hasIdenticalDelegate);
    }

    static QueryBuilder detectFilter(PhysicalPlan plan, String fieldName, Predicate<FieldAttribute> hasIdenticalDelegate) {
        QueryBuilder[] requestFilter = new QueryBuilder[]{null, null};
        plan.forEachDown(FragmentExec.class, fe -> {
            requestFilter[0] = fe.esFilter();
            fe.fragment().forEachUp(Filter.class, f -> {
                ArrayList<Expression> matches = new ArrayList<Expression>();
                if (f.child() instanceof EsRelation) {
                    List conjunctions = Predicates.splitAnd((Expression)f.condition());
                    for (Expression exp : conjunctions) {
                        AttributeSet refs = new AttributeSet((Collection)exp.references());
                        boolean matchesField = refs.removeIf(e -> fieldName.equals(e.name()));
                        if (!matchesField || !refs.isEmpty() || !LocalPhysicalPlanOptimizer.PushFiltersToSource.canPushToSource(exp, hasIdenticalDelegate)) continue;
                        matches.add(exp);
                    }
                }
                if (matches.size() > 0) {
                    requestFilter[1] = LocalPhysicalPlanOptimizer.TRANSLATOR_HANDLER.asQuery(Predicates.combineAnd(matches)).asBuilder();
                }
            });
        });
        return Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(requestFilter));
    }

    public static ElementType toSortableElementType(DataType dataType) {
        if (EsqlDataTypes.isSpatial(dataType)) {
            return ElementType.UNKNOWN;
        }
        return PlannerUtils.toElementType(dataType);
    }

    public static ElementType toElementType(DataType dataType) {
        return PlannerUtils.toElementType(dataType, MappedFieldType.FieldExtractPreference.NONE);
    }

    public static ElementType toElementType(DataType dataType, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        return switch (dataType) {
            default -> throw new IncompatibleClassChangeError();
            case DataType.LONG, DataType.DATETIME, DataType.UNSIGNED_LONG, DataType.COUNTER_LONG -> ElementType.LONG;
            case DataType.INTEGER, DataType.COUNTER_INTEGER -> ElementType.INT;
            case DataType.DOUBLE, DataType.COUNTER_DOUBLE -> ElementType.DOUBLE;
            case DataType.KEYWORD, DataType.TEXT, DataType.IP, DataType.SOURCE, DataType.VERSION, DataType.UNSUPPORTED -> ElementType.BYTES_REF;
            case DataType.NULL -> ElementType.NULL;
            case DataType.BOOLEAN -> ElementType.BOOLEAN;
            case DataType.DOC_DATA_TYPE -> ElementType.DOC;
            case DataType.TSID_DATA_TYPE -> ElementType.BYTES_REF;
            case DataType.GEO_POINT, DataType.CARTESIAN_POINT -> {
                if (fieldExtractPreference == MappedFieldType.FieldExtractPreference.DOC_VALUES) {
                    yield ElementType.LONG;
                }
                yield ElementType.BYTES_REF;
            }
            case DataType.GEO_SHAPE, DataType.CARTESIAN_SHAPE -> ElementType.BYTES_REF;
            case DataType.PARTIAL_AGG -> ElementType.COMPOSITE;
            case DataType.SHORT, DataType.BYTE, DataType.DATE_PERIOD, DataType.TIME_DURATION, DataType.OBJECT, DataType.NESTED, DataType.FLOAT, DataType.HALF_FLOAT, DataType.SCALED_FLOAT -> throw EsqlIllegalArgumentException.illegalDataType(dataType);
        };
    }

    public static MappedFieldType.FieldExtractPreference extractPreference(boolean hasPreference) {
        return hasPreference ? MappedFieldType.FieldExtractPreference.DOC_VALUES : MappedFieldType.FieldExtractPreference.NONE;
    }
}

