/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.List;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.Limit;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.meta.MetaFunctions;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.AbstractPhysicalOperationProviders;

public class Mapper {
    private final EsqlFunctionRegistry functionRegistry;
    private final boolean localMode;

    public Mapper(EsqlFunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
        this.localMode = false;
    }

    public Mapper(boolean localMode) {
        this.functionRegistry = null;
        this.localMode = localMode;
    }

    public PhysicalPlan map(LogicalPlan p) {
        if (p instanceof EsRelation) {
            EsRelation esRelation = (EsRelation)p;
            return this.localMode ? new EsSourceExec(esRelation) : new FragmentExec(p);
        }
        if (p instanceof Row) {
            Row row = (Row)p;
            return new RowExec(row.source(), row.fields());
        }
        if (p instanceof LocalRelation) {
            LocalRelation local = (LocalRelation)p;
            return new LocalSourceExec(local.source(), local.output(), local.supplier());
        }
        if (p instanceof MetaFunctions) {
            MetaFunctions metaFunctions = (MetaFunctions)p;
            return new ShowExec(metaFunctions.source(), metaFunctions.output(), metaFunctions.values(this.functionRegistry));
        }
        if (p instanceof ShowInfo) {
            ShowInfo showInfo = (ShowInfo)p;
            return new ShowExec(showInfo.source(), showInfo.output(), showInfo.values());
        }
        if (p instanceof UnaryPlan) {
            UnaryPlan ua = (UnaryPlan)p;
            PhysicalPlan child = this.map(ua.child());
            if (child instanceof FragmentExec) {
                Enrich enrich;
                if (p instanceof Enrich && (enrich = (Enrich)p).mode() == Enrich.Mode.COORDINATOR) {
                    assert (!this.localMode) : "coordinator enrich must not be included to a fragment and re-planned locally";
                    child = this.addExchangeForFragment(enrich.child(), child);
                    return this.map(enrich, child);
                }
                if (!Mapper.isPipelineBreaker(p)) {
                    return new FragmentExec(p);
                }
            }
            return this.map(ua, child);
        }
        if (p instanceof BinaryPlan) {
            BinaryPlan bp = (BinaryPlan)p;
            PhysicalPlan left = this.map(bp.left());
            PhysicalPlan right = this.map(bp.right());
            if (left instanceof FragmentExec) {
                if (right instanceof FragmentExec) {
                    throw new EsqlIllegalArgumentException("can't plan binary [" + p.nodeName() + "]");
                }
                return new FragmentExec(p);
            }
            if (right instanceof FragmentExec) {
                return new FragmentExec(p);
            }
            return this.map(bp, left, right);
        }
        throw new EsqlIllegalArgumentException("unsupported logical plan node [" + p.nodeName() + "]");
    }

    static boolean isPipelineBreaker(LogicalPlan p) {
        return p instanceof Aggregate || p instanceof TopN || p instanceof Limit || p instanceof OrderBy;
    }

    private PhysicalPlan map(UnaryPlan p, PhysicalPlan child) {
        if (p instanceof Filter) {
            Filter f = (Filter)p;
            return new FilterExec(f.source(), child, f.condition());
        }
        if (p instanceof Project) {
            Project pj = (Project)p;
            return new ProjectExec(pj.source(), child, pj.projections());
        }
        if (p instanceof Eval) {
            Eval eval = (Eval)p;
            return new EvalExec(eval.source(), child, eval.fields());
        }
        if (p instanceof Dissect) {
            Dissect dissect = (Dissect)p;
            return new DissectExec(dissect.source(), child, dissect.input(), dissect.parser(), dissect.extractedFields());
        }
        if (p instanceof Grok) {
            Grok grok = (Grok)p;
            return new GrokExec(grok.source(), child, grok.input(), grok.parser(), grok.extractedFields());
        }
        if (p instanceof Enrich) {
            Enrich enrich = (Enrich)p;
            return new EnrichExec(enrich.source(), child, enrich.mode(), enrich.policy().getType(), enrich.matchField(), BytesRefs.toString((Object)enrich.policyName().fold()), enrich.policy().getMatchField(), enrich.concreteIndices(), enrich.enrichFields());
        }
        if (p instanceof MvExpand) {
            MvExpand mvExpand = (MvExpand)p;
            return new MvExpandExec(mvExpand.source(), this.map(mvExpand.child()), mvExpand.target(), mvExpand.expanded());
        }
        if (p instanceof Limit) {
            Limit limit = (Limit)p;
            return this.map(limit, child);
        }
        if (p instanceof OrderBy) {
            OrderBy o = (OrderBy)p;
            return this.map(o, child);
        }
        if (p instanceof TopN) {
            TopN topN = (TopN)p;
            return this.map(topN, child);
        }
        if (p instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)p;
            return this.map(aggregate, child);
        }
        throw new EsqlIllegalArgumentException("unsupported logical plan node [" + p.nodeName() + "]");
    }

    private PhysicalPlan map(Aggregate aggregate, PhysicalPlan child) {
        if (this.localMode) {
            child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.PARTIAL);
        } else {
            if ((child = this.addExchangeForFragment((LogicalPlan)aggregate, child)) instanceof ExchangeExec) {
                ExchangeExec exchange = (ExchangeExec)child;
                List<Attribute> output = AbstractPhysicalOperationProviders.intermediateAttributes(aggregate.aggregates(), aggregate.groupings());
                child = new ExchangeExec(child.source(), output, true, exchange.child());
            } else {
                child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.PARTIAL);
            }
            child = Mapper.aggExec(aggregate, child, AggregateExec.Mode.FINAL);
        }
        return child;
    }

    private static AggregateExec aggExec(Aggregate aggregate, PhysicalPlan child, AggregateExec.Mode aggMode) {
        return new AggregateExec(aggregate.source(), child, aggregate.groupings(), aggregate.aggregates(), aggMode, null);
    }

    private PhysicalPlan map(Limit limit, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)limit, child);
        return new LimitExec(limit.source(), child, limit.limit());
    }

    private PhysicalPlan map(OrderBy o, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)o, child);
        return new OrderExec(o.source(), child, o.order());
    }

    private PhysicalPlan map(TopN topN, PhysicalPlan child) {
        child = this.addExchangeForFragment((LogicalPlan)topN, child);
        return new TopNExec(topN.source(), child, topN.order(), topN.limit(), null);
    }

    private PhysicalPlan addExchangeForFragment(LogicalPlan logical, PhysicalPlan child) {
        if (child instanceof FragmentExec) {
            child = new FragmentExec(logical);
            child = new ExchangeExec(child.source(), child);
        }
        return child;
    }

    private PhysicalPlan map(BinaryPlan p, PhysicalPlan lhs, PhysicalPlan rhs) {
        Join join;
        PhysicalPlan hash;
        if (p instanceof Join && (hash = this.tryHashJoin(join = (Join)p, lhs, rhs)) != null) {
            return hash;
        }
        throw new EsqlIllegalArgumentException("unsupported logical plan node [" + p.nodeName() + "]");
    }

    private PhysicalPlan tryHashJoin(Join join, PhysicalPlan lhs, PhysicalPlan rhs) {
        JoinConfig config = join.config();
        if (config.type() != JoinType.LEFT) {
            return null;
        }
        if (rhs instanceof LocalSourceExec) {
            LocalSourceExec local = (LocalSourceExec)rhs;
            return new HashJoinExec(join.source(), lhs, local, config.matchFields(), config.leftFields(), config.rightFields(), join.output());
        }
        return null;
    }
}

