/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.planner.Layout;

class ExchangeLayout
implements Layout {
    private final Layout delegate;
    private final List<Layout.ChannelSet> inverse;
    private final Map<NameId, NameId> mappingToOldLayout;
    private int counter;

    ExchangeLayout(Layout delegate) {
        this.delegate = delegate;
        this.inverse = delegate.inverse();
        this.mappingToOldLayout = new HashMap<NameId, NameId>(this.inverse.size());
    }

    @Override
    public Layout.ChannelAndType get(NameId id) {
        NameId oldId = this.mappingToOldLayout.get(id);
        if (oldId == null && this.counter < this.inverse.size()) {
            Set<NameId> names = this.inverse.get(this.counter++).nameIds();
            Iterator<NameId> iterator = names.iterator();
            while (iterator.hasNext()) {
                NameId name;
                oldId = name = iterator.next();
                this.mappingToOldLayout.put(id, oldId);
            }
        }
        return this.delegate.get(oldId);
    }

    @Override
    public int numberOfChannels() {
        return this.delegate.numberOfChannels();
    }

    public String toString() {
        return "ExchangeLayout{" + this.delegate + "}";
    }

    @Override
    public Layout.Builder builder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Layout.ChannelSet> inverse() {
        throw new UnsupportedOperationException();
    }
}

