/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.function.Supplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.MetadataAttribute;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNull;
import org.elasticsearch.xpack.esql.core.planner.TranslatorHandler;
import org.elasticsearch.xpack.esql.core.querydsl.query.Query;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.planner.EsqlExpressionTranslators;
import org.elasticsearch.xpack.esql.querydsl.query.SingleValueQuery;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public final class EsqlTranslatorHandler
implements TranslatorHandler {
    public Query asQuery(Expression e) {
        return EsqlExpressionTranslators.toQuery(e, this);
    }

    public Object convert(Object value, DataType dataType) {
        return EsqlDataTypeConverter.convert(value, dataType);
    }

    public Query wrapFunctionQuery(ScalarFunction sf, Expression field, Supplier<Query> querySupplier) {
        if (field instanceof FieldAttribute) {
            FieldAttribute exact;
            FieldAttribute fa = (FieldAttribute)field;
            if (fa.getExactInfo().hasExact() && (exact = fa.exactAttribute()) != fa) {
                fa = exact;
            }
            Query query = querySupplier.get();
            if (!(sf instanceof IsNull || sf instanceof IsNotNull)) {
                query = new SingleValueQuery(query, fa.name());
            }
            return query;
        }
        if (field instanceof MetadataAttribute) {
            return querySupplier.get();
        }
        throw new EsqlIllegalArgumentException("Expected a FieldAttribute or MetadataAttribute but received [" + field + "]");
    }

    public String nameOf(Expression e) {
        return Expressions.name((Expression)e);
    }
}

