/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Order;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class TopNExec
extends UnaryExec
implements EstimatesRowSize {
    private final Expression limit;
    private final List<Order> order;
    private final Integer estimatedRowSize;

    public TopNExec(Source source, PhysicalPlan child, List<Order> order, Expression limit, Integer estimatedRowSize) {
        super(source, child);
        this.order = order;
        this.limit = limit;
        this.estimatedRowSize = estimatedRowSize;
    }

    protected NodeInfo<TopNExec> info() {
        return NodeInfo.create((Node)this, TopNExec::new, (Object)((Object)this.child()), this.order, (Object)this.limit, (Object)this.estimatedRowSize);
    }

    @Override
    public TopNExec replaceChild(PhysicalPlan newChild) {
        return new TopNExec(this.source(), newChild, this.order, this.limit, this.estimatedRowSize);
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Order> order() {
        return this.order;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size = state.consumeAllFields(true);
        return Objects.equals(this.estimatedRowSize, size) ? this : new TopNExec(this.source(), this.child(), this.order, this.limit, size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.limit, this.estimatedRowSize);
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals = super.equals(obj);
        if (equals) {
            TopNExec other = (TopNExec)obj;
            equals = Objects.equals(this.order, other.order) && Objects.equals(this.limit, other.limit) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
        }
        return equals;
    }
}

