/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class MvExpandExec
extends UnaryExec {
    private final NamedExpression target;
    private final Attribute expanded;
    private final List<Attribute> output;

    public MvExpandExec(Source source, PhysicalPlan child, NamedExpression target, Attribute expanded) {
        super(source, child);
        this.target = target;
        this.expanded = expanded;
        this.output = MvExpand.calculateOutput(child.output(), target, expanded);
    }

    protected NodeInfo<MvExpandExec> info() {
        return NodeInfo.create((Node)this, MvExpandExec::new, (Object)((Object)this.child()), (Object)this.target, (Object)this.expanded);
    }

    @Override
    public MvExpandExec replaceChild(PhysicalPlan newChild) {
        return new MvExpandExec(this.source(), newChild, this.target, this.expanded);
    }

    public NamedExpression target() {
        return this.target;
    }

    public Attribute expanded() {
        return this.expanded;
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.target, this.child(), this.expanded});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MvExpandExec other = (MvExpandExec)((Object)obj);
        return Objects.equals(this.target, other.target) && Objects.equals((Object)this.child(), (Object)other.child()) && Objects.equals(this.expanded, other.expanded);
    }
}

