/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class ExchangeExec
extends UnaryExec {
    private final List<Attribute> output;
    private final boolean inBetweenAggs;

    public ExchangeExec(Source source, PhysicalPlan child) {
        this(source, Collections.emptyList(), false, child);
    }

    public ExchangeExec(Source source, List<Attribute> output, boolean inBetweenAggs, PhysicalPlan child) {
        super(source, child);
        this.output = output;
        this.inBetweenAggs = inBetweenAggs;
    }

    @Override
    public List<Attribute> output() {
        return this.output.isEmpty() ? super.output() : this.output;
    }

    public boolean isInBetweenAggs() {
        return this.inBetweenAggs;
    }

    @Override
    public UnaryExec replaceChild(PhysicalPlan newChild) {
        return new ExchangeExec(this.source(), this.output, this.inBetweenAggs, newChild);
    }

    protected NodeInfo<? extends PhysicalPlan> info() {
        return NodeInfo.create((Node)this, ExchangeExec::new, this.output, (Object)this.inBetweenAggs, (Object)((Object)this.child()));
    }
}

