/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.UnaryExec;

public class EnrichExec
extends UnaryExec
implements EstimatesRowSize {
    private final Enrich.Mode mode;
    private final String matchType;
    private final NamedExpression matchField;
    private final String policyName;
    private final String policyMatchField;
    private final Map<String, String> concreteIndices;
    private final List<NamedExpression> enrichFields;

    public EnrichExec(Source source, PhysicalPlan child, Enrich.Mode mode, String matchType, NamedExpression matchField, String policyName, String policyMatchField, Map<String, String> concreteIndices, List<NamedExpression> enrichFields) {
        super(source, child);
        this.mode = mode;
        this.matchType = matchType;
        this.matchField = matchField;
        this.policyName = policyName;
        this.policyMatchField = policyMatchField;
        this.concreteIndices = concreteIndices;
        this.enrichFields = enrichFields;
    }

    protected NodeInfo<EnrichExec> info() {
        return NodeInfo.create((Node)this, EnrichExec::new, (Object)((Object)this.child()), (Object)((Object)this.mode), (Object)this.matchType, (Object)this.matchField, (Object)this.policyName, (Object)this.policyMatchField, this.concreteIndices, this.enrichFields);
    }

    @Override
    public EnrichExec replaceChild(PhysicalPlan newChild) {
        return new EnrichExec(this.source(), newChild, this.mode, this.matchType, this.matchField, this.policyName, this.policyMatchField, this.concreteIndices, this.enrichFields);
    }

    public Enrich.Mode mode() {
        return this.mode;
    }

    public String matchType() {
        return this.matchType;
    }

    public NamedExpression matchField() {
        return this.matchField;
    }

    public Map<String, String> concreteIndices() {
        return this.concreteIndices;
    }

    public List<NamedExpression> enrichFields() {
        return this.enrichFields;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyMatchField() {
        return this.policyMatchField;
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.enrichFields, this.child().output());
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        state.add(false, this.enrichFields);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnrichExec that = (EnrichExec)o;
        return this.mode.equals((Object)that.mode) && Objects.equals(this.matchType, that.matchType) && Objects.equals(this.matchField, that.matchField) && Objects.equals(this.policyName, that.policyName) && Objects.equals(this.policyMatchField, that.policyMatchField) && Objects.equals(this.concreteIndices, that.concreteIndices) && Objects.equals(this.enrichFields, that.enrichFields);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode, this.matchType, this.matchField, this.policyName, this.policyMatchField, this.concreteIndices, this.enrichFields});
    }
}

