/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.EsqlFunctionRegistry;
import org.elasticsearch.xpack.esql.expression.function.FunctionDefinition;

public class MetaFunctions
extends LeafPlan {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public MetaFunctions(Source source) {
        super(source);
        for (String name : List.of("name", "synopsis", "argNames", "argTypes", "argDescriptions", "returnType", "description")) {
            this.attributes.add((Attribute)new ReferenceAttribute(Source.EMPTY, name, DataType.KEYWORD));
        }
        for (String name : List.of("optionalArgs", "variadic", "isAggregation")) {
            this.attributes.add((Attribute)new ReferenceAttribute(Source.EMPTY, name, DataType.BOOLEAN));
        }
    }

    public List<Attribute> output() {
        return this.attributes;
    }

    public List<List<Object>> values(EsqlFunctionRegistry functionRegistry) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        for (FunctionDefinition def : functionRegistry.listFunctions(null)) {
            EsqlFunctionRegistry.FunctionDescription signature = EsqlFunctionRegistry.description(def);
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(MetaFunctions.asBytesRefOrNull(signature.name()));
            row.add(new BytesRef((CharSequence)signature.fullSignature()));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::name));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::type));
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::description));
            row.add(MetaFunctions.withPipes(signature.returnType()));
            row.add(signature.description());
            row.add(this.collect(signature, EsqlFunctionRegistry.ArgSignature::optional));
            row.add(signature.variadic());
            row.add(signature.isAggregation());
            rows.add(row);
        }
        rows.sort(Comparator.comparing(x -> (BytesRef)x.get(0)));
        return rows;
    }

    private Object collect(EsqlFunctionRegistry.FunctionDescription signature, Function<EsqlFunctionRegistry.ArgSignature, ?> x) {
        if (signature.args().size() == 0) {
            return null;
        }
        if (signature.args().size() == 1) {
            Object result = x.apply(signature.args().get(0));
            if (result instanceof String[]) {
                String[] r = (String[])result;
                return MetaFunctions.withPipes(r);
            }
            return result;
        }
        List<EsqlFunctionRegistry.ArgSignature> args = signature.args();
        List result = signature.args().stream().map(x).collect(Collectors.toList());
        boolean withPipes = result.get(0) instanceof String[];
        if (!result.isEmpty()) {
            ArrayList newResult = new ArrayList();
            for (int i = 0; i < result.size(); ++i) {
                if (signature.variadic() && args.get(i).optional()) continue;
                newResult.add(withPipes ? MetaFunctions.withPipes((String[])result.get(i)) : result.get(i));
            }
            return newResult;
        }
        return result;
    }

    public static String withPipes(String[] items) {
        return Arrays.stream(items).collect(Collectors.joining("|"));
    }

    private static BytesRef asBytesRefOrNull(String string) {
        return Strings.hasText((String)string) ? new BytesRef((CharSequence)string) : null;
    }

    public boolean expressionsResolved() {
        return true;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }
}

