/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public enum JoinType implements Writeable
{
    INNER(0, "INNER"),
    LEFT(1, "LEFT OUTER"),
    RIGHT(2, "RIGHT OUTER"),
    FULL(3, "FULL OUTER"),
    CROSS(4, "CROSS");

    private final byte id;
    private final String name;

    private JoinType(int id, String name) {
        this.id = (byte)id;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id);
    }

    public static JoinType readFrom(StreamInput in) throws IOException {
        byte id = in.readByte();
        return switch (id) {
            case 0 -> INNER;
            case 1 -> LEFT;
            case 2 -> RIGHT;
            case 4 -> FULL;
            case 5 -> CROSS;
            default -> throw new IllegalArgumentException("unsupported join [" + id + "]");
        };
    }
}

