/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.BinaryPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinConfig;
import org.elasticsearch.xpack.esql.plan.logical.join.JoinType;

public class Join
extends BinaryPlan {
    private final JoinConfig config;
    private List<Attribute> lazyOutput;

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinConfig config) {
        super(source, left, right);
        this.config = config;
    }

    public Join(Source source, LogicalPlan left, LogicalPlan right, JoinType type, List<Attribute> matchFields, List<Attribute> leftFields, List<Attribute> rightFields) {
        super(source, left, right);
        this.config = new JoinConfig(type, matchFields, leftFields, rightFields);
    }

    public Join(PlanStreamInput in) throws IOException {
        super(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readLogicalPlanNode());
        this.config = new JoinConfig((StreamInput)in);
    }

    public void writeTo(PlanStreamOutput out) throws IOException {
        this.source().writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(this.left());
        out.writeLogicalPlanNode(this.right());
        this.config.writeTo(out);
    }

    public JoinConfig config() {
        return this.config;
    }

    protected NodeInfo<Join> info() {
        return NodeInfo.create((Node)this, Join::new, (Object)this.left(), (Object)this.right(), (Object)((Object)this.config.type()), this.config.matchFields(), this.config.leftFields(), this.config.rightFields());
    }

    public Join replaceChildren(List<LogicalPlan> newChildren) {
        return new Join(this.source(), newChildren.get(0), newChildren.get(1), this.config);
    }

    public Join replaceChildren(LogicalPlan left, LogicalPlan right) {
        return new Join(this.source(), left, right, this.config);
    }

    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = Join.computeOutput(this.left().output(), this.right().output(), this.config);
        }
        return this.lazyOutput;
    }

    public static List<Attribute> computeOutput(List<Attribute> leftOutput, List<Attribute> rightOutput, JoinConfig config) {
        AttributeSet matchFieldSet = new AttributeSet(config.matchFields());
        HashSet<String> matchFieldNames = new HashSet<String>(Expressions.names(config.matchFields()));
        return NamedExpressions.mergeOutputAttributes(Join.makeNullable(Join.makeReference(switch (config.type()) {
            case JoinType.LEFT -> Join.removeCollisionsWithMatchFields(rightOutput, matchFieldSet, matchFieldNames);
            default -> throw new UnsupportedOperationException("Other JOINs than LEFT not supported");
        })), leftOutput);
    }

    private static List<Attribute> removeCollisionsWithMatchFields(List<Attribute> attributes, AttributeSet matchFields, Set<String> matchFieldNames) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute attr : attributes) {
            if (matchFields.contains((Object)attr) || matchFieldNames.contains(attr.name())) continue;
            result.add(attr);
        }
        return result;
    }

    public static List<Attribute> makeReference(List<Attribute> output) {
        ArrayList<Attribute> out = new ArrayList<Attribute>(output.size());
        for (Attribute a : output) {
            if (a.resolved() && !(a instanceof ReferenceAttribute)) {
                out.add((Attribute)new ReferenceAttribute(a.source(), a.name(), a.dataType(), a.qualifier(), a.nullable(), a.id(), a.synthetic()));
                continue;
            }
            out.add(a);
        }
        return out;
    }

    public static List<Attribute> makeNullable(List<Attribute> output) {
        ArrayList<Attribute> out = new ArrayList<Attribute>(output.size());
        for (Attribute a : output) {
            out.add(a.withNullability(Nullability.TRUE));
        }
        return out;
    }

    public boolean expressionsResolved() {
        return this.config.expressionsResolved();
    }

    public boolean resolved() {
        return this.childrenResolved() && this.expressionsResolved();
    }

    public int hashCode() {
        return Objects.hash(this.config, this.left(), this.right());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Join other = (Join)((Object)obj);
        return this.config.equals(other.config) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }
}

