/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.core.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class UnresolvedRelation
extends LeafPlan
implements Unresolvable {
    private final TableIdentifier table;
    private final boolean frozen;
    private final String alias;
    private final String unresolvedMsg;

    public UnresolvedRelation(Source source, TableIdentifier table, String alias, boolean frozen) {
        this(source, table, alias, frozen, null);
    }

    public UnresolvedRelation(Source source, TableIdentifier table, String alias, boolean frozen, String unresolvedMessage) {
        super(source);
        this.table = table;
        this.alias = alias;
        this.frozen = frozen;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown index [" + table.index() + "]" : unresolvedMessage;
    }

    protected NodeInfo<UnresolvedRelation> info() {
        return NodeInfo.create((Node)this, UnresolvedRelation::new, (Object)this.table, (Object)this.alias, (Object)this.frozen, (Object)this.unresolvedMsg);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String alias() {
        return this.alias;
    }

    public boolean frozen() {
        return this.frozen;
    }

    public boolean resolved() {
        return false;
    }

    public boolean expressionsResolved() {
        return false;
    }

    public List<Attribute> output() {
        return Collections.emptyList();
    }

    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    public int hashCode() {
        return Objects.hash(this.source(), this.table, this.alias, this.unresolvedMsg);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedRelation other = (UnresolvedRelation)((Object)obj);
        return Objects.equals(this.table, other.table) && Objects.equals(this.alias, other.alias) && Objects.equals(this.frozen, other.frozen) && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }

    public List<Object> nodeProperties() {
        return Collections.singletonList(this.table);
    }

    public String toString() {
        return "?" + this.table.index();
    }
}

