/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Order;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class TopN
extends UnaryPlan {
    private final List<Order> order;
    private final Expression limit;

    public TopN(Source source, LogicalPlan child, List<Order> order, Expression limit) {
        super(source, child);
        this.order = order;
        this.limit = limit;
    }

    public boolean expressionsResolved() {
        return this.limit.resolved() && Resolvables.resolved(this.order);
    }

    protected NodeInfo<TopN> info() {
        return NodeInfo.create((Node)this, TopN::new, (Object)this.child(), this.order, (Object)this.limit);
    }

    public TopN replaceChild(LogicalPlan newChild) {
        return new TopN(this.source(), newChild, this.order, this.limit);
    }

    public Expression limit() {
        return this.limit;
    }

    public List<Order> order() {
        return this.order;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.order, this.limit);
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            TopN other = (TopN)((Object)obj);
            return Objects.equals(this.order, other.order) && Objects.equals(this.limit, other.limit);
        }
        return false;
    }
}

