/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.UnsupportedAttribute;

public class Rename
extends UnaryPlan {
    private final List<Alias> renamings;

    public Rename(Source source, LogicalPlan child, List<Alias> renamings) {
        super(source, child);
        this.renamings = renamings;
    }

    public List<Alias> renamings() {
        return this.renamings;
    }

    public List<Attribute> output() {
        List<NamedExpression> projectionsAfterResolution = Analyzer.ResolveRefs.projectionsForRename(this, this.child().output(), null);
        return Expressions.asAttributes(projectionsAfterResolution);
    }

    public boolean expressionsResolved() {
        for (Alias alias : this.renamings) {
            if (alias.resolved() || alias.child() instanceof UnsupportedAttribute) continue;
            return false;
        }
        return true;
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Rename(this.source(), newChild, this.renamings);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Rename::new, (Object)this.child(), this.renamings);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.renamings);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.renamings, ((Rename)((Object)obj)).renamings);
    }
}

