/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Functions;

public class Project
extends UnaryPlan {
    private final List<? extends NamedExpression> projections;

    public Project(Source source, LogicalPlan child, List<? extends NamedExpression> projections) {
        super(source, child);
        this.projections = projections;
    }

    protected NodeInfo<Project> info() {
        return NodeInfo.create((Node)this, Project::new, (Object)this.child(), this.projections);
    }

    public Project replaceChild(LogicalPlan newChild) {
        return new Project(this.source(), newChild, this.projections);
    }

    public List<? extends NamedExpression> projections() {
        return this.projections;
    }

    public Project withProjections(List<? extends NamedExpression> projections) {
        return new Project(this.source(), this.child(), projections);
    }

    public boolean resolved() {
        return super.resolved() && !Expressions.anyMatch(this.projections, Functions::isAggregate);
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.projections);
    }

    public List<Attribute> output() {
        return Expressions.asAttributes(this.projections);
    }

    public int hashCode() {
        return Objects.hash(this.projections, this.child());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Project other = (Project)((Object)obj);
        return Objects.equals(this.projections, other.projections) && Objects.equals(this.child(), other.child());
    }
}

