/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;

public class MvExpand
extends UnaryPlan {
    private final NamedExpression target;
    private final Attribute expanded;
    private List<Attribute> output;

    public MvExpand(Source source, LogicalPlan child, NamedExpression target, Attribute expanded) {
        super(source, child);
        this.target = target;
        this.expanded = expanded;
    }

    public static List<Attribute> calculateOutput(List<Attribute> input, NamedExpression target, Attribute expanded) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute attribute : input) {
            if (attribute.name().equals(target.name())) {
                result.add(expanded);
                continue;
            }
            result.add(attribute);
        }
        return result;
    }

    public NamedExpression target() {
        return this.target;
    }

    public Attribute expanded() {
        return this.expanded;
    }

    public boolean expressionsResolved() {
        return this.target.resolved();
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new MvExpand(this.source(), newChild, this.target, this.expanded);
    }

    public List<Attribute> output() {
        if (this.output == null) {
            this.output = MvExpand.calculateOutput(this.child().output(), this.target, this.expanded);
        }
        return this.output;
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, MvExpand::new, (Object)this.child(), (Object)this.target, (Object)this.expanded);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.target, this.expanded);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return Objects.equals(this.target, ((MvExpand)((Object)obj)).target) && Objects.equals(this.expanded, ((MvExpand)((Object)obj)).expanded);
    }
}

