/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;

public class Eval
extends UnaryPlan
implements GeneratingPlan<Eval> {
    private final List<Alias> fields;
    private List<Attribute> lazyOutput;

    public Eval(Source source, LogicalPlan child, List<Alias> fields) {
        super(source, child);
        this.fields = fields;
    }

    public List<Alias> fields() {
        return this.fields;
    }

    public List<Attribute> output() {
        if (this.lazyOutput == null) {
            this.lazyOutput = NamedExpressions.mergeOutputAttributes(this.fields, this.child().output());
        }
        return this.lazyOutput;
    }

    @Override
    public List<Attribute> generatedAttributes() {
        return Expressions.asAttributes(this.fields);
    }

    @Override
    public Eval withGeneratedNames(List<String> newNames) {
        this.checkNumberOfNewNames(newNames);
        return new Eval(this.source(), this.child(), this.renameAliases(this.fields, newNames));
    }

    private List<Alias> renameAliases(List<Alias> originalAttributes, List<String> newNames) {
        AttributeMap.Builder aliasReplacedByBuilder = AttributeMap.builder();
        ArrayList<Alias> newFields = new ArrayList<Alias>(originalAttributes.size());
        for (int i = 0; i < originalAttributes.size(); ++i) {
            Alias field = originalAttributes.get(i);
            String newName = newNames.get(i);
            if (field.name().equals(newName)) {
                newFields.add(field);
                continue;
            }
            Alias newField = new Alias(field.source(), newName, field.qualifier(), field.child(), new NameId(), field.synthetic());
            newFields.add(newField);
            aliasReplacedByBuilder.put(field.toAttribute(), (Object)newField.toAttribute());
        }
        AttributeMap aliasReplacedBy = aliasReplacedByBuilder.build();
        ArrayList<Alias> newFieldsWithUpdatedRefs = new ArrayList<Alias>(originalAttributes.size());
        for (Alias newField : newFields) {
            newFieldsWithUpdatedRefs.add((Alias)newField.transformUp(ReferenceAttribute.class, r -> (Expression)aliasReplacedBy.resolve(r, r)));
        }
        return newFieldsWithUpdatedRefs;
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.fields);
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Eval(this.source(), newChild, this.fields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Eval::new, (Object)this.child(), this.fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Eval eval = (Eval)o;
        return this.child().equals((Object)eval.child()) && Objects.equals(this.fields, eval.fields);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fields);
    }
}

