/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.Collection;
import java.util.List;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.plan.TableIdentifier;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.plan.logical.UnresolvedRelation;

public class EsqlUnresolvedRelation
extends UnresolvedRelation {
    private final List<Attribute> metadataFields;
    private final IndexMode indexMode;

    public EsqlUnresolvedRelation(Source source, TableIdentifier table, List<Attribute> metadataFields, IndexMode indexMode, String unresolvedMessage) {
        super(source, table, "", false, unresolvedMessage);
        this.metadataFields = metadataFields;
        this.indexMode = indexMode;
    }

    public EsqlUnresolvedRelation(Source source, TableIdentifier table, List<Attribute> metadataFields, IndexMode indexMode) {
        this(source, table, metadataFields, indexMode, null);
    }

    public List<Attribute> metadataFields() {
        return this.metadataFields;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public AttributeSet references() {
        AttributeSet refs = super.references();
        if (this.indexMode == IndexMode.TIME_SERIES) {
            refs = new AttributeSet((Collection)refs);
            refs.add((Attribute)new UnresolvedAttribute(this.source(), "@timestamp"));
        }
        return refs;
    }

    @Override
    protected NodeInfo<UnresolvedRelation> info() {
        return NodeInfo.create((Node)this, EsqlUnresolvedRelation::new, (Object)this.table(), this.metadataFields(), (Object)this.indexMode(), (Object)this.unresolvedMessage());
    }
}

