/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.index.EsIndex;
import org.elasticsearch.xpack.esql.core.plan.logical.LeafPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.NodeUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;

public class EsRelation
extends LeafPlan {
    private final EsIndex index;
    private final List<Attribute> attrs;
    private final boolean frozen;
    private final IndexMode indexMode;

    public EsRelation(Source source, EsIndex index, IndexMode indexMode, boolean frozen) {
        this(source, index, EsRelation.flatten(source, index.mapping()), indexMode, frozen);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes, IndexMode indexMode) {
        this(source, index, attributes, indexMode, false);
    }

    public EsRelation(Source source, EsIndex index, List<Attribute> attributes, IndexMode indexMode, boolean frozen) {
        super(source);
        this.index = index;
        this.attrs = attributes;
        this.indexMode = indexMode;
        this.frozen = frozen;
    }

    protected NodeInfo<EsRelation> info() {
        return NodeInfo.create((Node)this, EsRelation::new, (Object)this.index, this.attrs, (Object)this.indexMode, (Object)this.frozen);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping) {
        return EsRelation.flatten(source, mapping, null);
    }

    private static List<Attribute> flatten(Source source, Map<String, EsField> mapping, FieldAttribute parent) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (Map.Entry<String, EsField> entry : mapping.entrySet()) {
            String name = entry.getKey();
            EsField t = entry.getValue();
            if (t == null) continue;
            FieldAttribute f = new FieldAttribute(source, parent, (String)(parent != null ? parent.name() + "." + name : name), t);
            list.add((Attribute)f);
            if (t.getProperties().isEmpty()) continue;
            list.addAll(EsRelation.flatten(source, t.getProperties(), f));
        }
        return list;
    }

    public EsIndex index() {
        return this.index;
    }

    public boolean frozen() {
        return this.frozen;
    }

    public IndexMode indexMode() {
        return this.indexMode;
    }

    public List<Attribute> output() {
        return this.attrs;
    }

    public boolean expressionsResolved() {
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.indexMode, this.frozen, this.attrs);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EsRelation other = (EsRelation)((Object)obj);
        return Objects.equals(this.index, other.index) && this.indexMode == other.indexMode() && this.frozen == other.frozen && Objects.equals(this.attrs, other.attrs);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.index + "]" + NodeUtils.limitedToString(this.attrs);
    }
}

