/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;

public class Dissect
extends RegexExtract {
    private final Parser parser;

    public Dissect(Source source, LogicalPlan child, Expression input, Parser parser, List<Attribute> extracted) {
        super(source, child, input, extracted);
        this.parser = parser;
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Dissect(this.source(), newChild, this.input, this.parser, this.extractedFields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Dissect::new, (Object)this.child(), (Object)this.input, (Object)this.parser, (Object)this.extractedFields);
    }

    @Override
    public Dissect withGeneratedNames(List<String> newNames) {
        return new Dissect(this.source(), this.child(), this.input, this.parser, this.renameExtractedFields(newNames));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Dissect dissect = (Dissect)o;
        return Objects.equals(this.parser, dissect.parser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parser);
    }

    public Parser parser() {
        return this.parser;
    }

    public record Parser(String pattern, String appendSeparator, DissectParser parser) {
        public List<Attribute> keyAttributes(Source src) {
            ArrayList<Attribute> keys = new ArrayList<Attribute>();
            for (String x : this.parser.outputKeys()) {
                if (x.isEmpty()) continue;
                keys.add((Attribute)new ReferenceAttribute(src, x, DataType.KEYWORD));
            }
            return keys;
        }

        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Parser that = (Parser)other;
            return Objects.equals(this.pattern, that.pattern) && Objects.equals(this.appendSeparator, that.appendSeparator);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern, this.appendSeparator);
        }
    }
}

