/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.core.capabilities.Resolvables;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class Aggregate
extends UnaryPlan {
    private final AggregateType aggregateType;
    private final List<Expression> groupings;
    private final List<? extends NamedExpression> aggregates;

    public Aggregate(Source source, LogicalPlan child, AggregateType aggregateType, List<Expression> groupings, List<? extends NamedExpression> aggregates) {
        super(source, child);
        this.aggregateType = aggregateType;
        this.groupings = groupings;
        this.aggregates = aggregates;
    }

    public Aggregate(PlanStreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), AggregateType.readType((StreamInput)in), in.readNamedWriteableCollectionAsList(Expression.class), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    public static void writeAggregate(PlanStreamOutput out, Aggregate aggregate) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(aggregate.child());
        AggregateType.writeType(out, aggregate.aggregateType());
        out.writeNamedWriteableCollection(aggregate.groupings);
        out.writeNamedWriteableCollection(aggregate.aggregates());
    }

    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create((Node)this, Aggregate::new, (Object)this.child(), (Object)((Object)this.aggregateType), this.groupings, this.aggregates);
    }

    public Aggregate replaceChild(LogicalPlan newChild) {
        return new Aggregate(this.source(), newChild, this.aggregateType, this.groupings, this.aggregates);
    }

    public AggregateType aggregateType() {
        return this.aggregateType;
    }

    public List<Expression> groupings() {
        return this.groupings;
    }

    public List<? extends NamedExpression> aggregates() {
        return this.aggregates;
    }

    public boolean expressionsResolved() {
        return Resolvables.resolved(this.groupings) && Resolvables.resolved(this.aggregates);
    }

    public List<Attribute> output() {
        return Expressions.asAttributes(this.aggregates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aggregateType, this.groupings, this.aggregates, this.child()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Aggregate other = (Aggregate)((Object)obj);
        return this.aggregateType == other.aggregateType && Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals(this.child(), other.child());
    }

    public static enum AggregateType {
        STANDARD,
        METRICS;


        static void writeType(StreamOutput out, AggregateType type) throws IOException {
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_AGGREGATE_TYPE)) {
                out.writeString(type.name());
            } else if (type != STANDARD) {
                throw new IllegalStateException("cluster is not ready to support aggregate type [" + type + "]");
            }
        }

        static AggregateType readType(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_AGGREGATE_TYPE)) {
                return AggregateType.valueOf(in.readString());
            }
            return STANDARD;
        }
    }
}

