/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public String visitIdentifier(EsqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.QUOTED_IDENTIFIER(), ctx.UNQUOTED_IDENTIFIER());
    }

    protected static String unquoteIdentifier(TerminalNode quotedNode, TerminalNode unquotedNode) {
        String result = quotedNode != null ? IdentifierBuilder.unquoteIdString(quotedNode.getText()) : unquotedNode.getText();
        return result;
    }

    protected static String unquoteIdString(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1).replace("``", "`");
    }

    @Override
    public String visitIndexString(EsqlBaseParser.IndexStringContext ctx) {
        TerminalNode n = ctx.UNQUOTED_SOURCE();
        return n != null ? n.getText() : IdentifierBuilder.unquote(ctx.QUOTED_STRING().getText());
    }

    public String visitIndexPattern(List<EsqlBaseParser.IndexPatternContext> ctx) {
        ArrayList patterns = new ArrayList(ctx.size());
        ctx.forEach(c -> {
            String indexPattern = this.visitIndexString(c.indexString());
            patterns.add(c.clusterString() != null ? c.clusterString().getText() + ":" + indexPattern : indexPattern);
        });
        return Strings.collectionToDelimitedString(patterns, (String)",");
    }
}

