/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.BitSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.core.parser.CaseChangingCharStream;
import org.elasticsearch.xpack.esql.core.parser.ParserUtils;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.parser.AstBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseLexer;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParserBaseListener;
import org.elasticsearch.xpack.esql.parser.LogicalPlanBuilder;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.QueryParams;

public class EsqlParser {
    private static final Logger log = LogManager.getLogger(EsqlParser.class);
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, (Exception)e, line, charPositionInLine);
        }
    };

    public LogicalPlan createStatement(String query) {
        return this.createStatement(query, new QueryParams());
    }

    public LogicalPlan createStatement(String query, QueryParams params) {
        if (log.isDebugEnabled()) {
            log.debug("Parsing as statement: {}", new Object[]{query});
        }
        return this.invokeParser(query, params, EsqlBaseParser::singleStatement, LogicalPlanBuilder::plan);
    }

    private <T> T invokeParser(String query, QueryParams params, Function<EsqlBaseParser, ParserRuleContext> parseFunction, BiFunction<AstBuilder, ParserRuleContext, T> result) {
        try {
            EsqlBaseLexer lexer = new EsqlBaseLexer((CharStream)new CaseChangingCharStream((CharStream)CharStreams.fromString((String)query), false));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ParametrizedTokenSource tokenSource = new ParametrizedTokenSource((TokenSource)lexer, params);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)tokenSource);
            EsqlBaseParser parser = new EsqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor());
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            ParserRuleContext tree = parseFunction.apply(parser);
            if (log.isTraceEnabled()) {
                log.trace("Parse tree: {}", new Object[]{tree.toStringTree()});
            }
            return result.apply(new AstBuilder(params), tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException("ESQL statement is too large, causing stack overflow when generating the parsing tree: [{}]", query);
        }
    }

    private static class ParametrizedTokenSource
    implements TokenSource {
        private static String message = "Inconsistent parameter declaration, use one of positional, named or anonymous params but not a combination of ";
        private TokenSource delegate;
        private QueryParams params;
        private BitSet paramTypes = new BitSet(3);
        private int param = 1;

        ParametrizedTokenSource(TokenSource delegate, QueryParams params) {
            this.delegate = delegate;
            this.params = params;
        }

        public Token nextToken() {
            Token token = this.delegate.nextToken();
            if (token.getType() == 52) {
                this.checkAnonymousParam(token);
                if (this.param > this.params.size()) {
                    throw new ParsingException(ParserUtils.source((Token)token), "Not enough actual parameters {}", this.params.size());
                }
                this.params.addTokenParam(token, this.params.get(this.param));
                ++this.param;
            }
            if (token.getType() == 68) {
                if (StringUtils.isInteger((String)token.getText().substring(1))) {
                    this.checkPositionalParam(token);
                } else {
                    this.checkNamedParam(token);
                }
            }
            return token;
        }

        public int getLine() {
            return this.delegate.getLine();
        }

        public int getCharPositionInLine() {
            return this.delegate.getCharPositionInLine();
        }

        public CharStream getInputStream() {
            return this.delegate.getInputStream();
        }

        public String getSourceName() {
            return this.delegate.getSourceName();
        }

        public void setTokenFactory(TokenFactory<?> factory) {
            this.delegate.setTokenFactory(factory);
        }

        public TokenFactory<?> getTokenFactory() {
            return this.delegate.getTokenFactory();
        }

        private void checkAnonymousParam(Token token) {
            this.paramTypes.set(0);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source((Token)token), message + "anonymous and " + (this.paramTypes.get(1) ? "named" : "positional"), new Object[0]);
            }
        }

        private void checkNamedParam(Token token) {
            this.paramTypes.set(1);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source((Token)token), message + "named and " + (this.paramTypes.get(0) ? "anonymous" : "positional"), new Object[0]);
            }
        }

        private void checkPositionalParam(Token token) {
            this.paramTypes.set(2);
            if (this.paramTypes.cardinality() > 1) {
                throw new ParsingException(ParserUtils.source((Token)token), message + "positional and " + (this.paramTypes.get(0) ? "anonymous" : "named"), new Object[0]);
            }
        }
    }

    private class PostProcessor
    extends EsqlBaseParserBaseListener {
        private PostProcessor() {
        }

        @Override
        public void exitFunctionExpression(EsqlBaseParser.FunctionExpressionContext ctx) {
            EsqlBaseParser.IdentifierContext identifier = ctx.identifier();
            if (identifier.getText().equalsIgnoreCase("is_null")) {
                throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "is_null function is not supported anymore, please use 'is null'/'is not null' predicates instead", new Object[0]);
            }
        }
    }
}

