/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.esql.core.parser.ParserUtils;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParserBaseVisitor;

abstract class AbstractBuilder
extends EsqlBaseParserBaseVisitor<Object> {
    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        return ParserUtils.visit(x$0 -> super.visit(x$0), (ParseTree)tree);
    }

    public Source visitTerminal(TerminalNode node) {
        return ParserUtils.source((TerminalNode)node);
    }

    static String unquote(Source source) {
        return AbstractBuilder.unquote(source.text());
    }

    static String unquote(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("\"\"\"")) {
            return string.substring(3, string.length() - 3);
        }
        string = string.substring(1, string.length() - 1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '\\') {
                switch (string.charAt(++i)) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\').append(string.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            sb.append(string.charAt(i++));
        }
        return sb.toString();
    }
}

