/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.EmptyAttribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Rate;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public final class SubstituteSurrogates
extends OptimizerRules.OptimizerRule<Aggregate> {
    public SubstituteSurrogates() {
        super(OptimizerRules.TransformDirection.UP);
    }

    /*
     * WARNING - void declaration
     */
    protected LogicalPlan rule(Aggregate aggregate) {
        void var8_16;
        List<? extends NamedExpression> aggs = aggregate.aggregates();
        ArrayList<NamedExpression> newAggs = new ArrayList<NamedExpression>(aggs.size());
        HashMap<AggregateFunction, Attribute> aggFuncToAttr = new HashMap<AggregateFunction, Attribute>();
        ArrayList<Alias> transientEval = new ArrayList<Alias>();
        boolean changed = false;
        for (NamedExpression namedExpression : aggs) {
            SurrogateExpression se;
            AggregateFunction aggregateFunction;
            Expression expression = Alias.unwrap((Expression)namedExpression);
            if (!(expression instanceof AggregateFunction) || (aggregateFunction = (AggregateFunction)expression) instanceof SurrogateExpression && (se = (SurrogateExpression)((Object)aggregateFunction)).surrogate() != null) continue;
            aggFuncToAttr.put(aggregateFunction, namedExpression.toAttribute());
        }
        int[] counter = new int[]{0};
        for (NamedExpression namedExpression : aggs) {
            SurrogateExpression sf;
            Expression e = Alias.unwrap((Expression)namedExpression);
            if (e instanceof SurrogateExpression && (sf = (SurrogateExpression)e).surrogate() != null) {
                changed = true;
                Expression s = sf.surrogate();
                if (!(s instanceof AggregateFunction)) {
                    Expression surrogateWithRefs = (Expression)s.transformUp(AggregateFunction.class, af -> {
                        if (af instanceof Rate) {
                            return af;
                        }
                        Attribute attr = (Attribute)aggFuncToAttr.get(af);
                        if (attr == null) {
                            int n = counter[0];
                            counter[0] = n + 1;
                            String temporaryName = LogicalPlanOptimizer.temporaryName((Expression)af, (Expression)agg, n);
                            Alias newAlias = new Alias(agg.source(), temporaryName, null, (Expression)af, null, true);
                            attr = newAlias.toAttribute();
                            aggFuncToAttr.put((AggregateFunction)((Object)((Object)af)), attr);
                            newAggs.add((NamedExpression)newAlias);
                        }
                        return attr;
                    });
                    Alias aliased = new Alias(namedExpression.source(), namedExpression.name(), null, surrogateWithRefs, namedExpression.toAttribute().id());
                    transientEval.add(aliased);
                    continue;
                }
                newAggs.add((NamedExpression)namedExpression.replaceChildren(Collections.singletonList(s)));
                continue;
            }
            newAggs.add(namedExpression);
        }
        Aggregate aggregate2 = aggregate;
        if (changed) {
            Source source = aggregate.source();
            if (!newAggs.isEmpty()) {
                Aggregate aggregate3 = new Aggregate(source, aggregate.child(), aggregate.aggregateType(), aggregate.groupings(), newAggs);
            } else {
                LocalRelation localRelation = new LocalRelation(source, List.of(new EmptyAttribute(source)), LocalSupplier.of(new Block[]{BlockUtils.constantBlock((BlockFactory)PlannerUtils.NON_BREAKING_BLOCK_FACTORY, null, (int)1)}));
            }
            if (!transientEval.isEmpty()) {
                void var8_13;
                Eval eval = new Eval(source, (LogicalPlan)var8_13, transientEval);
                Project project = new Project(source, (LogicalPlan)eval, Expressions.asAttributes(aggs));
            }
        }
        return var8_16;
    }
}

