/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;

public final class SplitInWithFoldableValue
extends OptimizerRules.OptimizerExpressionRule<In> {
    public SplitInWithFoldableValue() {
        super(OptimizerRules.TransformDirection.UP);
    }

    public Expression rule(In in) {
        if (in.value().foldable()) {
            ArrayList<Expression> foldables = new ArrayList<Expression>(in.list().size());
            ArrayList<Expression> nonFoldables = new ArrayList<Expression>(in.list().size());
            in.list().forEach(e -> {
                if (e.foldable() && !Expressions.isNull((Expression)e)) {
                    foldables.add((Expression)e);
                } else {
                    nonFoldables.add((Expression)e);
                }
            });
            if (foldables.size() > 0 && nonFoldables.size() > 0) {
                In withFoldables = new In(in.source(), in.value(), foldables);
                In withoutFoldables = new In(in.source(), in.value(), nonFoldables);
                return new Or(in.source(), (Expression)withFoldables, (Expression)withoutFoldables);
            }
        }
        return in;
    }
}

