/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;

public final class ReplaceStatsAggExpressionWithEval
extends OptimizerRules.OptimizerRule<Aggregate> {
    public ReplaceStatsAggExpressionWithEval() {
        super(OptimizerRules.TransformDirection.UP);
    }

    protected LogicalPlan rule(Aggregate aggregate) {
        AttributeMap aliases = new AttributeMap();
        aggregate.forEachExpressionUp(Alias.class, a -> aliases.put(a.toAttribute(), (Object)a.child()));
        List<? extends NamedExpression> aggs = aggregate.aggregates();
        LinkedHashMap rootAggs = Maps.newLinkedHashMapWithExpectedSize((int)aggs.size());
        ArrayList<Alias> newEvals = new ArrayList<Alias>();
        ArrayList<Object> newProjections = new ArrayList<Object>();
        ArrayList<Object> newAggs = new ArrayList<Object>();
        Holder changed = new Holder((Object)false);
        int[] counter = new int[]{0};
        for (NamedExpression namedExpression : aggs) {
            if (namedExpression instanceof Alias) {
                Alias as = (Alias)namedExpression;
                Expression child = as.child();
                if (child instanceof AggregateFunction) {
                    AggregateFunction af2 = (AggregateFunction)child;
                    AggregateFunction canonical = (AggregateFunction)af2.canonical();
                    Expression field = (Expression)canonical.field().transformUp(e -> (Expression)aliases.resolve(e, e));
                    Alias found = (Alias)rootAggs.get((Object)(canonical = (AggregateFunction)canonical.replaceChildren(CollectionUtils.combine((Collection[])new Collection[]{Collections.singleton(field), canonical.parameters()}))));
                    if (found == null) {
                        rootAggs.put(canonical, as);
                        newAggs.add(as);
                        newProjections.add(as.toAttribute());
                        continue;
                    }
                    changed.set((Object)true);
                    newProjections.add(as.replaceChild((Expression)found.toAttribute()));
                    continue;
                }
                changed.set((Object)true);
                Expression aggExpression = (Expression)child.transformUp(AggregateFunction.class, af -> {
                    AggregateFunction canonical = (AggregateFunction)af.canonical();
                    Alias alias = (Alias)rootAggs.get((Object)canonical);
                    if (alias == null) {
                        int n = counter[0];
                        counter[0] = n + 1;
                        alias = new Alias(af.source(), ReplaceStatsAggExpressionWithEval.syntheticName((Expression)canonical, child, n), as.qualifier(), (Expression)canonical, null, true);
                        rootAggs.put(canonical, alias);
                        newAggs.add(alias);
                    }
                    return alias.toAttribute();
                });
                Alias alias = as.replaceChild(aggExpression);
                newEvals.add(alias);
                newProjections.add(alias.toAttribute());
                continue;
            }
            newAggs.add(namedExpression);
            newProjections.add(namedExpression.toAttribute());
        }
        UnaryPlan plan = aggregate;
        if (((Boolean)changed.get()).booleanValue()) {
            Source source = aggregate.source();
            plan = new Aggregate(source, aggregate.child(), aggregate.aggregateType(), aggregate.groupings(), newAggs);
            if (newEvals.size() > 0) {
                plan = new Eval(source, (LogicalPlan)plan, newEvals);
            }
            plan = new Project(source, (LogicalPlan)plan, newProjections);
        }
        return plan;
    }

    static String syntheticName(Expression expression, Expression af, int counter) {
        return LogicalPlanOptimizer.temporaryName(expression, af, counter);
    }
}

