/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.predicate.nulls.IsNotNull;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.StringPattern;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;

public final class ReplaceRegexMatch
extends OptimizerRules.OptimizerExpressionRule<RegexMatch<?>> {
    public ReplaceRegexMatch() {
        super(OptimizerRules.TransformDirection.DOWN);
    }

    public Expression rule(RegexMatch<?> regexMatch) {
        IsNotNull e = regexMatch;
        StringPattern pattern = regexMatch.pattern();
        if (pattern.matchesAll()) {
            e = new IsNotNull(e.source(), regexMatch.field());
        } else {
            String match = pattern.exactMatch();
            if (match != null) {
                Literal literal = new Literal(regexMatch.source(), (Object)match, DataType.KEYWORD);
                e = this.regexToEquals((RegexMatch<?>)regexMatch, literal);
            }
        }
        return e;
    }

    protected Expression regexToEquals(RegexMatch<?> regexMatch, Literal literal) {
        return new Equals(regexMatch.source(), regexMatch.field(), (Expression)literal);
    }
}

