/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.rule.Rule;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;

public final class ReplaceAliasingEvalWithProject
extends Rule<LogicalPlan, LogicalPlan> {
    public LogicalPlan apply(LogicalPlan logicalPlan) {
        Holder enabled = new Holder((Object)false);
        return (LogicalPlan)logicalPlan.transformDown(p -> {
            if (p instanceof Aggregate || p instanceof Project) {
                enabled.set((Object)true);
            } else if (((Boolean)enabled.get()).booleanValue() && p instanceof Eval) {
                Eval eval = (Eval)p;
                p = this.rule(eval);
            }
            return p;
        });
    }

    private LogicalPlan rule(Eval eval) {
        UnaryPlan plan = eval;
        AttributeMap basicAliases = new AttributeMap();
        AttributeMap basicAliasSources = new AttributeMap();
        ArrayList<Alias> keptFields = new ArrayList<Alias>();
        List<Alias> fields = eval.fields();
        int size = fields.size();
        for (int i = 0; i < size; ++i) {
            Alias field = fields.get(i);
            Expression child = field.child();
            Attribute attribute = field.toAttribute();
            if (child instanceof Attribute) {
                basicAliases.put(attribute, (Object)child);
                basicAliasSources.put(attribute, (Object)field);
                continue;
            }
            if (basicAliases.size() > 0) {
                field = (Alias)field.transformUp(e -> (Expression)basicAliases.resolve(e, e));
            }
            keptFields.add(field);
        }
        if (basicAliases.size() > 0) {
            ArrayList<Attribute> projections = new ArrayList<Attribute>(eval.output());
            for (int i = projections.size() - 1; i >= 0; --i) {
                NamedExpression project = (NamedExpression)projections.get(i);
                projections.set(i, (Attribute)((NamedExpression)basicAliasSources.getOrDefault((Object)project, (Object)project)));
            }
            Object child = eval.child();
            if (keptFields.size() > 0) {
                child = new Eval(eval.source(), eval.child(), keptFields);
            }
            plan = new Project(eval.source(), (LogicalPlan)child, (List<? extends NamedExpression>)projections);
        }
        return plan;
    }
}

