/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xpack.esql.core.analyzer.AnalyzerRules;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;

public final class RemoveStatsOverride
extends AnalyzerRules.AnalyzerRule<Aggregate> {
    protected boolean skipResolved() {
        return false;
    }

    protected LogicalPlan rule(Aggregate agg) {
        return agg.resolved() ? RemoveStatsOverride.removeAggDuplicates(agg) : agg;
    }

    private static Aggregate removeAggDuplicates(Aggregate agg) {
        List<Expression> groupings = agg.groupings();
        List<? extends NamedExpression> aggregates = agg.aggregates();
        groupings = RemoveStatsOverride.removeDuplicateNames(groupings);
        aggregates = RemoveStatsOverride.removeDuplicateNames(aggregates);
        return new Aggregate(agg.source(), agg.child(), agg.aggregateType(), groupings, aggregates);
    }

    private static <T extends Expression> List<T> removeDuplicateNames(List<T> list) {
        ArrayList<T> newList = new ArrayList<T>(list);
        HashSet nameSet = Sets.newHashSetWithExpectedSize((int)list.size());
        for (int i = list.size() - 1; i >= 0; --i) {
            Expression element = (Expression)list.get(i);
            String name = Expressions.name((Expression)element);
            if (nameSet.add(name)) continue;
            newList.remove(i);
        }
        return newList.size() == list.size() ? list : newList;
    }
}

