/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;

public final class PushDownAndCombineFilters
extends OptimizerRules.OptimizerRule<Filter> {
    protected LogicalPlan rule(Filter filter) {
        Filter plan = filter;
        LogicalPlan child = filter.child();
        Expression condition = filter.condition();
        if (child instanceof Filter) {
            Filter f = (Filter)child;
            plan = f.with(Predicates.combineAnd(List.of(f.condition(), condition)));
        } else if (child instanceof Aggregate) {
            Aggregate agg = (Aggregate)child;
            plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, agg, e -> e instanceof Attribute && agg.output().contains(e) && !agg.groupings().contains(e) || e instanceof AggregateFunction);
        } else if (child instanceof Eval) {
            Eval eval = (Eval)child;
            AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(eval.fields()));
            plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, eval, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
        } else if (child instanceof RegexExtract) {
            RegexExtract re = (RegexExtract)child;
            AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(re.extractedFields()));
            plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, re, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
        } else if (child instanceof Enrich) {
            Enrich enrich = (Enrich)child;
            AttributeSet attributes = new AttributeSet((Collection)Expressions.asAttributes(enrich.enrichFields()));
            plan = PushDownAndCombineFilters.maybePushDownPastUnary(filter, enrich, arg_0 -> ((AttributeSet)attributes).contains(arg_0));
        } else {
            if (child instanceof Project) {
                return LogicalPlanOptimizer.pushDownPastProject((UnaryPlan)filter);
            }
            if (child instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)child;
                plan = orderBy.replaceChild((LogicalPlan)filter.with(orderBy.child(), condition));
            }
        }
        return plan;
    }

    private static LogicalPlan maybePushDownPastUnary(Filter filter, UnaryPlan unary, Predicate<Expression> cannotPush) {
        Filter plan;
        ArrayList pushable = new ArrayList();
        ArrayList<Expression> nonPushable = new ArrayList<Expression>();
        for (Expression exp : Predicates.splitAnd((Expression)filter.condition())) {
            (exp.anyMatch(cannotPush) ? nonPushable : pushable).add(exp);
        }
        if (pushable.size() > 0) {
            if (nonPushable.size() > 0) {
                Filter pushed = new Filter(filter.source(), unary.child(), Predicates.combineAnd(pushable));
                plan = filter.with((LogicalPlan)unary.replaceChild((LogicalPlan)pushed), Predicates.combineAnd(nonPushable));
            } else {
                plan = unary.replaceChild((LogicalPlan)filter.with(unary.child(), filter.condition()));
            }
        } else {
            plan = filter;
        }
        return plan;
    }
}

