/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;

public final class PruneOrderByBeforeStats
extends OptimizerRules.OptimizerRule<Aggregate> {
    protected LogicalPlan rule(Aggregate agg) {
        OrderBy order = PruneOrderByBeforeStats.findPullableOrderBy(agg.child());
        Aggregate p = agg;
        if (order != null) {
            p = (LogicalPlan)agg.transformDown(OrderBy.class, o -> o == order ? order.child() : o);
        }
        return p;
    }

    private static OrderBy findPullableOrderBy(LogicalPlan plan) {
        OrderBy pullable = null;
        if (plan instanceof OrderBy) {
            OrderBy o;
            pullable = o = (OrderBy)plan;
        } else if (plan instanceof Eval || plan instanceof Filter || plan instanceof Project || plan instanceof RegexExtract || plan instanceof Enrich) {
            pullable = PruneOrderByBeforeStats.findPullableOrderBy(((UnaryPlan)plan).child());
        }
        return pullable;
    }
}

