/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.optimizer.LogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;

public class PropagateEmptyRelation
extends OptimizerRules.OptimizerRule<UnaryPlan> {
    protected LogicalPlan rule(UnaryPlan plan) {
        LocalRelation local;
        UnaryPlan p = plan;
        LogicalPlan logicalPlan = plan.child();
        if (logicalPlan instanceof LocalRelation && (local = (LocalRelation)logicalPlan).supplier() == LocalSupplier.EMPTY) {
            Aggregate agg;
            if (plan instanceof Aggregate && (agg = (Aggregate)plan).groupings().isEmpty()) {
                List<Block> emptyBlocks = this.aggsFromEmpty(agg.aggregates());
                p = LogicalPlanOptimizer.skipPlan(plan, LocalSupplier.of((Block[])emptyBlocks.toArray(Block[]::new)));
            } else {
                p = LogicalPlanOptimizer.skipPlan(plan);
            }
        }
        return p;
    }

    private List<Block> aggsFromEmpty(List<? extends NamedExpression> aggs) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockFactory blockFactory = PlannerUtils.NON_BREAKING_BLOCK_FACTORY;
        boolean i = false;
        for (NamedExpression namedExpression : aggs) {
            Expression expression = Alias.unwrap((Expression)namedExpression);
            if (expression instanceof AggregateFunction) {
                AggregateFunction aggFunc = (AggregateFunction)expression;
                this.aggOutput(namedExpression, aggFunc, blockFactory, blocks);
                continue;
            }
            throw new EsqlIllegalArgumentException("Did not expect a non-aliased aggregation {}", namedExpression);
        }
        return blocks;
    }

    protected void aggOutput(NamedExpression agg, AggregateFunction aggFunc, BlockFactory blockFactory, List<Block> blocks) {
        Count count;
        Long value = aggFunc instanceof Count && (!(count = (Count)aggFunc).foldable() || count.fold() != null) ? Long.valueOf(0L) : null;
        BlockUtils.BuilderWrapper wrapper = BlockUtils.wrapperFor((BlockFactory)blockFactory, (ElementType)PlannerUtils.toElementType(aggFunc.dataType()), (int)1);
        wrapper.accept((Object)value);
        blocks.add(wrapper.builder().build());
    }
}

