/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.Limit;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;

public final class DuplicateLimitAfterMvExpand
extends OptimizerRules.OptimizerRule<Limit> {
    protected LogicalPlan rule(Limit limit) {
        Limit limitBeforeMvExpand;
        UnaryPlan unary;
        MvExpand mvExpand;
        boolean shouldSkip;
        LogicalPlan child = limit.child();
        boolean bl = shouldSkip = child instanceof Eval || child instanceof Project || child instanceof RegexExtract || child instanceof Enrich || child instanceof Limit;
        if (!shouldSkip && child instanceof UnaryPlan && (mvExpand = DuplicateLimitAfterMvExpand.descendantMvExpand(unary = (UnaryPlan)child)) != null && (limitBeforeMvExpand = DuplicateLimitAfterMvExpand.limitBeforeMvExpand(mvExpand)) == null) {
            Limit duplicateLimit = new Limit(limit.source(), limit.limit(), mvExpand.child());
            return limit.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, unary));
        }
        return limit;
    }

    private static MvExpand descendantMvExpand(UnaryPlan unary) {
        UnaryPlan plan = unary;
        AttributeSet filterReferences = new AttributeSet();
        while (!(plan instanceof Aggregate)) {
            UnaryPlan unaryPlan;
            if (plan instanceof MvExpand) {
                MvExpand mve = (MvExpand)plan;
                if (!filterReferences.isEmpty() && (filterReferences.contains((Object)mve.target()) || mve.target() instanceof ReferenceAttribute || filterReferences.stream().anyMatch(ref -> ref instanceof ReferenceAttribute))) {
                    return null;
                }
                return mve;
            }
            if (plan instanceof Filter) {
                Filter filter = (Filter)plan;
                filterReferences.addAll(filter.references());
            } else if (plan instanceof OrderBy) {
                return null;
            }
            LogicalPlan logicalPlan = plan.child();
            if (!(logicalPlan instanceof UnaryPlan)) break;
            plan = unaryPlan = (UnaryPlan)logicalPlan;
        }
        return null;
    }

    private static Limit limitBeforeMvExpand(MvExpand mvExpand) {
        MvExpand plan = mvExpand;
        while (!(plan instanceof Aggregate)) {
            if (plan instanceof Limit) {
                Limit limit = (Limit)plan;
                return limit;
            }
            LogicalPlan logicalPlan = plan.child();
            if (!(logicalPlan instanceof UnaryPlan)) break;
            UnaryPlan unaryPlan = (UnaryPlan)logicalPlan;
            plan = unaryPlan;
        }
        return null;
    }

    private LogicalPlan propagateDuplicateLimitUntilMvExpand(Limit duplicateLimit, MvExpand mvExpand, UnaryPlan child) {
        if (child == mvExpand) {
            return mvExpand.replaceChild((LogicalPlan)duplicateLimit);
        }
        return child.replaceChild(this.propagateDuplicateLimitUntilMvExpand(duplicateLimit, mvExpand, (UnaryPlan)child.child()));
    }
}

