/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Predicates;
import org.elasticsearch.xpack.esql.core.expression.predicate.logical.Or;
import org.elasticsearch.xpack.esql.core.optimizer.OptimizerRules;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.In;

public final class CombineDisjunctionsToIn
extends OptimizerRules.OptimizerExpressionRule<Or> {
    public CombineDisjunctionsToIn() {
        super(OptimizerRules.TransformDirection.UP);
    }

    protected In createIn(Expression key, List<Expression> values, ZoneId zoneId) {
        return new In(key.source(), key, values);
    }

    protected Equals createEquals(Expression k, Set<Expression> v, ZoneId finalZoneId) {
        return new Equals(k.source(), k, v.iterator().next(), finalZoneId);
    }

    public Expression rule(Or or) {
        Or e = or;
        List exps = Predicates.splitOr((Expression)e);
        LinkedHashMap<Expression, Set> found = new LinkedHashMap<Expression, Set>();
        ZoneId zoneId = null;
        LinkedList<Expression> ors = new LinkedList<Expression>();
        for (Expression exp : exps) {
            if (exp instanceof Equals) {
                Equals eq = (Equals)exp;
                if (eq.right().foldable()) {
                    found.computeIfAbsent(eq.left(), k -> new LinkedHashSet()).add(eq.right());
                } else {
                    ors.add(exp);
                }
                if (zoneId != null) continue;
                zoneId = eq.zoneId();
                continue;
            }
            if (exp instanceof In) {
                In in = (In)exp;
                found.computeIfAbsent(in.value(), k -> new LinkedHashSet()).addAll(in.list());
                if (zoneId != null) continue;
                zoneId = in.zoneId();
                continue;
            }
            ors.add(exp);
        }
        if (!found.isEmpty()) {
            ZoneId finalZoneId = zoneId;
            found.forEach((k, v) -> ors.add((Expression)(v.size() == 1 ? this.createEquals((Expression)k, (Set<Expression>)v, finalZoneId) : this.createIn((Expression)k, (List<Expression>)new ArrayList<Expression>((Collection<Expression>)v), finalZoneId))));
            Expression combineOr = Predicates.combineOr(ors);
            if (!e.semanticEquals(combineOr)) {
                e = combineOr;
            }
        }
        return e;
    }
}

