/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.Collection;
import java.util.HashSet;
import org.elasticsearch.xpack.esql.core.common.Failure;
import org.elasticsearch.xpack.esql.core.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.plan.QueryPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EsStatsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.RegexExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;

class OptimizerRules {
    private OptimizerRules() {
    }

    static class PhysicalPlanDependencyCheck
    extends DependencyConsistency<PhysicalPlan> {
        PhysicalPlanDependencyCheck() {
        }

        @Override
        protected AttributeSet generates(PhysicalPlan physicalPlan) {
            if (physicalPlan instanceof EsSourceExec || physicalPlan instanceof EsStatsQueryExec || physicalPlan instanceof EsQueryExec || physicalPlan instanceof LocalSourceExec || physicalPlan instanceof RowExec || physicalPlan instanceof ExchangeExec || physicalPlan instanceof ExchangeSourceExec || physicalPlan instanceof AggregateExec || physicalPlan instanceof ShowExec) {
                return physicalPlan.outputSet();
            }
            if (physicalPlan instanceof FieldExtractExec) {
                FieldExtractExec fieldExtractExec = (FieldExtractExec)physicalPlan;
                return new AttributeSet(fieldExtractExec.attributesToExtract());
            }
            if (physicalPlan instanceof EvalExec) {
                EvalExec eval = (EvalExec)physicalPlan;
                return new AttributeSet((Collection)Expressions.asAttributes(eval.fields()));
            }
            if (physicalPlan instanceof RegexExtractExec) {
                RegexExtractExec extract = (RegexExtractExec)physicalPlan;
                return new AttributeSet(extract.extractedFields());
            }
            if (physicalPlan instanceof MvExpandExec) {
                MvExpandExec mvExpand = (MvExpandExec)physicalPlan;
                return new AttributeSet(mvExpand.expanded());
            }
            if (physicalPlan instanceof EnrichExec) {
                EnrichExec enrich = (EnrichExec)physicalPlan;
                return new AttributeSet((Collection)Expressions.asAttributes(enrich.enrichFields()));
            }
            return AttributeSet.EMPTY;
        }

        @Override
        protected AttributeSet references(PhysicalPlan plan) {
            AggregateExec aggregate;
            if (plan instanceof AggregateExec && (aggregate = (AggregateExec)plan).getMode() == AggregateExec.Mode.FINAL) {
                return aggregate.inputSet();
            }
            return plan.references();
        }
    }

    static class LogicalPlanDependencyCheck
    extends DependencyConsistency<LogicalPlan> {
        LogicalPlanDependencyCheck() {
        }

        @Override
        protected AttributeSet references(LogicalPlan plan) {
            if (plan instanceof Enrich) {
                Enrich enrich = (Enrich)plan;
                return enrich.matchField().references();
            }
            return super.references(plan);
        }

        @Override
        protected AttributeSet generates(LogicalPlan logicalPlan) {
            if (logicalPlan instanceof EsRelation || logicalPlan instanceof LocalRelation || logicalPlan instanceof Row || logicalPlan instanceof Aggregate) {
                return logicalPlan.outputSet();
            }
            if (logicalPlan instanceof GeneratingPlan) {
                GeneratingPlan generating = (GeneratingPlan)logicalPlan;
                return new AttributeSet(generating.generatedAttributes());
            }
            if (logicalPlan instanceof MvExpand) {
                MvExpand mvExpand = (MvExpand)logicalPlan;
                return new AttributeSet(mvExpand.expanded());
            }
            return AttributeSet.EMPTY;
        }
    }

    static class DependencyConsistency<P extends QueryPlan<P>> {
        DependencyConsistency() {
        }

        void checkPlan(P p, Failures failures) {
            AttributeSet refs = this.references(p);
            AttributeSet input = p.inputSet();
            AttributeSet generated = this.generates(p);
            AttributeSet missing = refs.subtract(input).subtract(generated);
            if (!missing.isEmpty()) {
                failures.add(Failure.fail(p, (String)"Plan [{}] optimized incorrectly due to missing references {}", (Object[])new Object[]{p.nodeString(), missing}));
            }
            HashSet<String> outputAttributeNames = new HashSet<String>();
            HashSet<NameId> outputAttributeIds = new HashSet<NameId>();
            for (Attribute outputAttr : p.output()) {
                if (outputAttributeNames.add(outputAttr.name()) && outputAttributeIds.add(outputAttr.id())) continue;
                failures.add(Failure.fail(p, (String)"Plan [{}] optimized incorrectly due to duplicate output attribute {}", (Object[])new Object[]{p.nodeString(), outputAttr.toString()}));
            }
        }

        protected AttributeSet references(P p) {
            return p.references();
        }

        protected AttributeSet generates(P p) {
            return AttributeSet.EMPTY;
        }
    }
}

