/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import org.elasticsearch.xpack.esql.capabilities.Validatable;
import org.elasticsearch.xpack.esql.core.common.Failures;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.optimizer.OptimizerRules;

public final class LogicalVerifier {
    private static final OptimizerRules.LogicalPlanDependencyCheck DEPENDENCY_CHECK = new OptimizerRules.LogicalPlanDependencyCheck();
    public static final LogicalVerifier INSTANCE = new LogicalVerifier();

    private LogicalVerifier() {
    }

    public Failures verify(LogicalPlan plan) {
        Failures failures = new Failures();
        Failures dependencyFailures = new Failures();
        plan.forEachUp(p -> {
            DEPENDENCY_CHECK.checkPlan(p, dependencyFailures);
            if (!failures.hasFailures()) {
                p.forEachExpression(ex -> {
                    if (ex instanceof Validatable) {
                        Validatable v = (Validatable)ex;
                        v.validate(failures);
                    }
                });
            }
        });
        if (dependencyFailures.hasFailures()) {
            throw new IllegalStateException(dependencyFailures.toString());
        }
        return failures;
    }
}

