/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.core.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.esql.core.rule.ParameterizedRule;
import org.elasticsearch.xpack.esql.core.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.core.rule.Rule;
import org.elasticsearch.xpack.esql.core.rule.RuleExecutor;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LogicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.AddDefaultTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.BooleanFunctionEqualsElimination;
import org.elasticsearch.xpack.esql.optimizer.rules.BooleanSimplification;
import org.elasticsearch.xpack.esql.optimizer.rules.CombineDisjunctionsToIn;
import org.elasticsearch.xpack.esql.optimizer.rules.CombineEvals;
import org.elasticsearch.xpack.esql.optimizer.rules.CombineProjections;
import org.elasticsearch.xpack.esql.optimizer.rules.ConstantFolding;
import org.elasticsearch.xpack.esql.optimizer.rules.ConvertStringToByteRef;
import org.elasticsearch.xpack.esql.optimizer.rules.DuplicateLimitAfterMvExpand;
import org.elasticsearch.xpack.esql.optimizer.rules.FoldNull;
import org.elasticsearch.xpack.esql.optimizer.rules.LiteralsOnTheRight;
import org.elasticsearch.xpack.esql.optimizer.rules.PartiallyFoldCase;
import org.elasticsearch.xpack.esql.optimizer.rules.PropagateEmptyRelation;
import org.elasticsearch.xpack.esql.optimizer.rules.PropagateEquals;
import org.elasticsearch.xpack.esql.optimizer.rules.PropagateEvalFoldables;
import org.elasticsearch.xpack.esql.optimizer.rules.PropagateNullable;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneColumns;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneEmptyPlans;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneLiteralsInOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneOrderByBeforeStats;
import org.elasticsearch.xpack.esql.optimizer.rules.PruneRedundantSortClauses;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownAndCombineFilters;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownAndCombineLimits;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownAndCombineOrderBy;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownEnrich;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownEval;
import org.elasticsearch.xpack.esql.optimizer.rules.PushDownRegexExtract;
import org.elasticsearch.xpack.esql.optimizer.rules.RemoveStatsOverride;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceAliasingEvalWithProject;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceLimitAndSortAsTopN;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceLookupWithJoin;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceOrderByExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceRegexMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceStatsAggExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceStatsNestedExpressionWithEval;
import org.elasticsearch.xpack.esql.optimizer.rules.ReplaceTrivialTypeConversions;
import org.elasticsearch.xpack.esql.optimizer.rules.SetAsOptimized;
import org.elasticsearch.xpack.esql.optimizer.rules.SimplifyComparisonsArithmetics;
import org.elasticsearch.xpack.esql.optimizer.rules.SkipQueryOnEmptyMappings;
import org.elasticsearch.xpack.esql.optimizer.rules.SkipQueryOnLimitZero;
import org.elasticsearch.xpack.esql.optimizer.rules.SplitInWithFoldableValue;
import org.elasticsearch.xpack.esql.optimizer.rules.SubstituteSpatialSurrogates;
import org.elasticsearch.xpack.esql.optimizer.rules.SubstituteSurrogates;
import org.elasticsearch.xpack.esql.optimizer.rules.TranslateMetricsAggregate;
import org.elasticsearch.xpack.esql.plan.GeneratingPlan;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalSupplier;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;

public class LogicalPlanOptimizer
extends ParameterizedRuleExecutor<LogicalPlan, LogicalOptimizerContext> {
    private final LogicalVerifier verifier = LogicalVerifier.INSTANCE;
    static int TO_STRING_LIMIT = 16;

    public LogicalPlanOptimizer(LogicalOptimizerContext optimizerContext) {
        super((Object)optimizerContext);
    }

    public static String temporaryName(Expression inner, Expression outer, int suffix) {
        String in = LogicalPlanOptimizer.toString(inner);
        String out = LogicalPlanOptimizer.toString(outer);
        return LogicalPlanOptimizer.rawTemporaryName(in, out, String.valueOf(suffix));
    }

    public static String locallyUniqueTemporaryName(String inner, String outer) {
        return "$$" + inner + "$" + outer + "$" + new NameId();
    }

    public static String rawTemporaryName(String inner, String outer, String suffix) {
        return "$$" + inner + "$" + outer + "$" + suffix;
    }

    static String toString(Expression ex) {
        String string;
        if (ex instanceof AggregateFunction) {
            AggregateFunction af = (AggregateFunction)ex;
            string = af.functionName();
        } else {
            string = LogicalPlanOptimizer.extractString(ex);
        }
        return string;
    }

    static String extractString(Expression ex) {
        String string;
        if (ex instanceof NamedExpression) {
            NamedExpression ne = (NamedExpression)ex;
            string = ne.name();
        } else {
            string = LogicalPlanOptimizer.limitToString(ex.sourceText()).replace(' ', '_');
        }
        return string;
    }

    static String limitToString(String string) {
        return string.length() > TO_STRING_LIMIT ? string.substring(0, TO_STRING_LIMIT - 1) + ">" : string;
    }

    public LogicalPlan optimize(LogicalPlan verified) {
        LogicalPlan optimized = (LogicalPlan)this.execute((Node)verified);
        Failures failures = this.verifier.verify(optimized);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return optimized;
    }

    protected List<RuleExecutor.Batch<LogicalPlan>> batches() {
        return LogicalPlanOptimizer.rules();
    }

    protected static RuleExecutor.Batch<LogicalPlan> substitutions() {
        return new RuleExecutor.Batch("Substitutions", RuleExecutor.Limiter.ONCE, new Rule[]{new ReplaceLookupWithJoin(), new RemoveStatsOverride(), new ReplaceStatsNestedExpressionWithEval(), new ReplaceStatsAggExpressionWithEval(), new SubstituteSurrogates(), new TranslateMetricsAggregate(), new ReplaceStatsNestedExpressionWithEval(), new ReplaceRegexMatch(), new ReplaceTrivialTypeConversions(), new ReplaceAliasingEvalWithProject(), new SkipQueryOnEmptyMappings(), new SubstituteSpatialSurrogates(), new ReplaceOrderByExpressionWithEval()});
    }

    protected static RuleExecutor.Batch<LogicalPlan> operators() {
        return new RuleExecutor.Batch("Operator Optimization", new Rule[]{new CombineProjections(), new CombineEvals(), new PruneEmptyPlans(), new PropagateEmptyRelation(), new ConvertStringToByteRef(), new FoldNull(), new SplitInWithFoldableValue(), new PropagateEvalFoldables(), new ConstantFolding(), new PartiallyFoldCase(), new BooleanSimplification(), new LiteralsOnTheRight(), new PropagateEquals(), new PropagateNullable(), new BooleanFunctionEqualsElimination(), new CombineDisjunctionsToIn(), new SimplifyComparisonsArithmetics(EsqlDataTypes::areCompatible), new PruneFilters(), new PruneColumns(), new PruneLiteralsInOrderBy(), new PushDownAndCombineLimits(), new DuplicateLimitAfterMvExpand(), new PushDownAndCombineFilters(), new PushDownEval(), new PushDownRegexExtract(), new PushDownEnrich(), new PushDownAndCombineOrderBy(), new PruneOrderByBeforeStats(), new PruneRedundantSortClauses()});
    }

    protected static RuleExecutor.Batch<LogicalPlan> cleanup() {
        return new RuleExecutor.Batch("Clean Up", new Rule[]{new ReplaceLimitAndSortAsTopN()});
    }

    protected static List<RuleExecutor.Batch<LogicalPlan>> rules() {
        RuleExecutor.Batch skip = new RuleExecutor.Batch("Skip Compute", new Rule[]{new SkipQueryOnLimitZero()});
        RuleExecutor.Batch defaultTopN = new RuleExecutor.Batch("Add default TopN", new Rule[]{new AddDefaultTopN()});
        RuleExecutor.Batch label = new RuleExecutor.Batch("Set as Optimized", RuleExecutor.Limiter.ONCE, new Rule[]{new SetAsOptimized()});
        return Arrays.asList(LogicalPlanOptimizer.substitutions(), LogicalPlanOptimizer.operators(), skip, LogicalPlanOptimizer.cleanup(), defaultTopN, label);
    }

    public static LogicalPlan skipPlan(UnaryPlan plan) {
        return new LocalRelation(plan.source(), plan.output(), LocalSupplier.EMPTY);
    }

    public static LogicalPlan skipPlan(UnaryPlan plan, LocalSupplier supplier) {
        return new LocalRelation(plan.source(), plan.output(), supplier);
    }

    public static <Plan extends UnaryPlan> LogicalPlan pushGeneratingPlanPastProjectAndOrderBy(Plan generatingPlan) {
        LogicalPlan child = generatingPlan.child();
        if (child instanceof OrderBy) {
            OrderBy orderBy = (OrderBy)child;
            LinkedHashSet<String> evalFieldNames = new LinkedHashSet<String>(Expressions.names(((GeneratingPlan)generatingPlan).generatedAttributes()));
            AttributeReplacement nonShadowedOrders = LogicalPlanOptimizer.renameAttributesInExpressions(evalFieldNames, orderBy.order());
            AttributeMap<Alias> aliasesForShadowedOrderByAttrs = nonShadowedOrders.replacedAttributes;
            List<Expression> newOrder = nonShadowedOrders.rewrittenExpressions;
            if (!aliasesForShadowedOrderByAttrs.isEmpty()) {
                ArrayList<Alias> arrayList = new ArrayList<Alias>(aliasesForShadowedOrderByAttrs.values());
                UnaryPlan plan = new Eval(orderBy.source(), orderBy.child(), arrayList);
                plan = generatingPlan.replaceChild((LogicalPlan)plan);
                plan = new OrderBy(orderBy.source(), (LogicalPlan)plan, newOrder);
                plan = new Project(generatingPlan.source(), (LogicalPlan)plan, generatingPlan.output());
                return plan;
            }
            return orderBy.replaceChild((LogicalPlan)generatingPlan.replaceChild(orderBy.child()));
        }
        if (child instanceof Project) {
            Project project = (Project)child;
            List<Attribute> generatedAttributes = ((GeneratingPlan)generatingPlan).generatedAttributes();
            UnaryPlan generatingPlanWithResolvedExpressions = LogicalPlanOptimizer.resolveRenamesFromProject(generatingPlan, project);
            HashSet<String> namesReferencedInRenames = new HashSet<String>();
            for (NamedExpression namedExpression : project.projections()) {
                if (!(namedExpression instanceof Alias)) continue;
                Alias as = (Alias)namedExpression;
                namesReferencedInRenames.addAll(as.child().references().names());
            }
            Map<String, String> renameGeneratedAttributeTo = LogicalPlanOptimizer.newNamesForConflictingAttributes(((GeneratingPlan)generatingPlan).generatedAttributes(), namesReferencedInRenames);
            List<String> list = generatedAttributes.stream().map(attr -> renameGeneratedAttributeTo.getOrDefault(attr.name(), attr.name())).toList();
            UnaryPlan generatingPlanWithRenamedAttributes = (UnaryPlan)((GeneratingPlan)generatingPlanWithResolvedExpressions).withGeneratedNames(list);
            ArrayList<Object> generatedAttributesRenamedToOriginal = new ArrayList<Object>(generatedAttributes.size());
            List<Attribute> renamedGeneratedAttributes = ((GeneratingPlan)generatingPlanWithRenamedAttributes).generatedAttributes();
            for (int i = 0; i < generatedAttributes.size(); ++i) {
                Attribute originalAttribute = generatedAttributes.get(i);
                Attribute renamedAttribute = renamedGeneratedAttributes.get(i);
                if (originalAttribute.name().equals(renamedAttribute.name())) {
                    generatedAttributesRenamedToOriginal.add(renamedAttribute);
                    continue;
                }
                generatedAttributesRenamedToOriginal.add(new Alias(originalAttribute.source(), originalAttribute.name(), originalAttribute.qualifier(), (Expression)renamedAttribute, originalAttribute.id(), originalAttribute.synthetic()));
            }
            Project projectWithGeneratingChild = project.replaceChild((LogicalPlan)generatingPlanWithRenamedAttributes.replaceChild(project.child()));
            return projectWithGeneratingChild.withProjections(NamedExpressions.mergeOutputExpressions(generatedAttributesRenamedToOriginal, projectWithGeneratingChild.projections()));
        }
        return generatingPlan;
    }

    private static AttributeReplacement renameAttributesInExpressions(Set<String> attributeNamesToRename, List<? extends Expression> expressions) {
        AttributeMap aliasesForReplacedAttributes = new AttributeMap();
        ArrayList<Expression> rewrittenExpressions = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            rewrittenExpressions.add((Expression)expression.transformUp(Attribute.class, attr -> {
                if (attributeNamesToRename.contains(attr.name())) {
                    Alias renamedAttribute = (Alias)aliasesForReplacedAttributes.computeIfAbsent(attr, a -> {
                        String tempName = LogicalPlanOptimizer.locallyUniqueTemporaryName(a.name(), "temp_name");
                        return new Alias(a.source(), tempName, null, (Expression)a, null, false);
                    });
                    return renamedAttribute.toAttribute();
                }
                return attr;
            }));
        }
        return new AttributeReplacement(rewrittenExpressions, (AttributeMap<Alias>)aliasesForReplacedAttributes);
    }

    private static Map<String, String> newNamesForConflictingAttributes(List<Attribute> potentiallyConflictingAttributes, Set<String> reservedNames) {
        if (reservedNames.isEmpty()) {
            return Map.of();
        }
        HashMap<String, String> renameAttributeTo = new HashMap<String, String>();
        for (Attribute attr : potentiallyConflictingAttributes) {
            String name = attr.name();
            if (!reservedNames.contains(name)) continue;
            renameAttributeTo.putIfAbsent(name, LogicalPlanOptimizer.locallyUniqueTemporaryName(name, "temp_name"));
        }
        return renameAttributeTo;
    }

    public static Project pushDownPastProject(UnaryPlan parent) {
        LogicalPlan logicalPlan = parent.child();
        if (logicalPlan instanceof Project) {
            Project project = (Project)logicalPlan;
            UnaryPlan expressionsWithResolvedAliases = LogicalPlanOptimizer.resolveRenamesFromProject(parent, project);
            return project.replaceChild((LogicalPlan)expressionsWithResolvedAliases.replaceChild(project.child()));
        }
        throw new EsqlIllegalArgumentException("Expected child to be instance of Project");
    }

    private static UnaryPlan resolveRenamesFromProject(UnaryPlan plan, Project project) {
        AttributeMap.Builder aliasBuilder = AttributeMap.builder();
        project.forEachExpression(Alias.class, a -> aliasBuilder.put(a.toAttribute(), (Object)a.child()));
        AttributeMap aliases = aliasBuilder.build();
        return (UnaryPlan)plan.transformExpressionsOnly(ReferenceAttribute.class, r -> (Expression)aliases.resolve(r, r));
    }

    private record AttributeReplacement(List<Expression> rewrittenExpressions, AttributeMap<Alias> replacedAttributes) {
    }

    public static abstract class ParameterizedOptimizerRule<SubPlan extends LogicalPlan, P>
    extends ParameterizedRule<SubPlan, LogicalPlan, P> {
        public final LogicalPlan apply(LogicalPlan plan, P context) {
            return (LogicalPlan)plan.transformDown(this.typeToken(), t -> this.rule(t, context));
        }

        protected abstract LogicalPlan rule(SubPlan var1, P var2);
    }
}

