/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanNamedTypes;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

public final class PlanStreamOutput
extends StreamOutput {
    private final Map<Block, BytesReference> cachedBlocks = new IdentityHashMap<Block, BytesReference>();
    private final StreamOutput delegate;
    private final PlanNameRegistry registry;
    private final Function<Class<?>, String> nameSupplier;
    private int nextCachedBlock = 0;
    static final byte NEW_BLOCK_KEY = 0;
    static final byte FROM_PREVIOUS_KEY = 1;
    static final byte FROM_CONFIG_KEY = 2;

    public PlanStreamOutput(StreamOutput delegate, PlanNameRegistry registry, @Nullable EsqlConfiguration configuration) throws IOException {
        this(delegate, registry, configuration, PlanNamedTypes::name);
    }

    public PlanStreamOutput(StreamOutput delegate, PlanNameRegistry registry, @Nullable EsqlConfiguration configuration, Function<Class<?>, String> nameSupplier) throws IOException {
        this.delegate = delegate;
        this.registry = registry;
        this.nameSupplier = nameSupplier;
        if (configuration != null) {
            for (Map.Entry<String, Map<String, Column>> table : configuration.tables().entrySet()) {
                for (Map.Entry<String, Column> column : table.getValue().entrySet()) {
                    this.cachedBlocks.put(column.getValue().values(), PlanStreamOutput.fromConfigKey(table.getKey(), column.getKey()));
                }
            }
        }
    }

    public void writeLogicalPlanNode(LogicalPlan logicalPlan) throws IOException {
        assert (logicalPlan.children().size() <= 1 || logicalPlan instanceof Join && logicalPlan.children().size() == 2);
        this.writeNamed(LogicalPlan.class, logicalPlan);
    }

    public void writePhysicalPlanNode(PhysicalPlan physicalPlan) throws IOException {
        assert (physicalPlan.children().size() <= 1);
        this.writeNamed(PhysicalPlan.class, physicalPlan);
    }

    public void writeOptionalPhysicalPlanNode(PhysicalPlan physicalPlan) throws IOException {
        if (physicalPlan == null) {
            this.writeBoolean(false);
        } else {
            this.writeBoolean(true);
            this.writePhysicalPlanNode(physicalPlan);
        }
    }

    public <T> void writeNamed(Class<T> type, T value) throws IOException {
        String name = this.nameSupplier.apply(value.getClass());
        PlanNameRegistry.PlanWriter<T> writer = this.registry.getWriter(type, name);
        this.writeString(name);
        writer.write(this, value);
    }

    public void writeByte(byte b) throws IOException {
        this.delegate.writeByte(b);
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.delegate.writeBytes(b, offset, length);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public TransportVersion getTransportVersion() {
        return this.delegate.getTransportVersion();
    }

    public void setTransportVersion(TransportVersion version) {
        this.delegate.setTransportVersion(version);
        super.setTransportVersion(version);
    }

    public void writeCachedBlock(Block block) throws IOException {
        assert (!(block instanceof LongBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof IntBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof DoubleBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof BooleanBigArrayBlock)) : "BigArrays not supported because we don't close";
        BytesReference key = this.cachedBlocks.get(block);
        if (key != null) {
            key.writeTo((OutputStream)((Object)this));
            return;
        }
        this.writeByte((byte)0);
        this.writeVInt(this.nextCachedBlock);
        this.cachedBlocks.put(block, PlanStreamOutput.fromPreviousKey(this.nextCachedBlock));
        this.writeNamedWriteable((NamedWriteable)block);
        ++this.nextCachedBlock;
    }

    static BytesReference fromPreviousKey(int id) throws IOException {
        try (BytesStreamOutput key = new BytesStreamOutput();){
            key.writeByte((byte)1);
            key.writeVInt(id);
            BytesReference bytesReference = key.bytes();
            return bytesReference;
        }
    }

    static BytesReference fromConfigKey(String table, String column) throws IOException {
        try (BytesStreamOutput key = new BytesStreamOutput();){
            key.writeByte((byte)2);
            key.writeString(table);
            key.writeString(column);
            BytesReference bytesReference = key.bytes();
            return bytesReference;
        }
    }
}

