/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongFunction;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.BlockUtils;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.DoubleBigArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.Column;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

public final class PlanStreamInput
extends NamedWriteableAwareStreamInput
implements org.elasticsearch.xpack.esql.core.util.PlanStreamInput {
    private final Map<Integer, Block> cachedBlocks = new HashMap<Integer, Block>();
    private final PlanNameRegistry registry;
    private final LongFunction<NameId> nameIdFunction;
    private final EsqlConfiguration configuration;

    public PlanStreamInput(StreamInput streamInput, PlanNameRegistry registry, NamedWriteableRegistry namedWriteableRegistry, EsqlConfiguration configuration) {
        super(streamInput, namedWriteableRegistry);
        this.registry = registry;
        this.configuration = configuration;
        this.nameIdFunction = new NameIdMapper();
    }

    public LogicalPlan readLogicalPlanNode() throws IOException {
        return this.readNamed(LogicalPlan.class);
    }

    public PhysicalPlan readPhysicalPlanNode() throws IOException {
        return this.readNamed(PhysicalPlan.class);
    }

    public PhysicalPlan readOptionalPhysicalPlanNode() throws IOException {
        return this.readOptionalNamed(PhysicalPlan.class);
    }

    public <T> T readNamed(Class<T> type) throws IOException {
        String name = this.readString();
        PlanNameRegistry.PlanReader<T> reader = this.registry.getReader(type, name);
        if (reader instanceof PlanNameRegistry.PlanNamedReader) {
            PlanNameRegistry.PlanNamedReader namedReader = (PlanNameRegistry.PlanNamedReader)reader;
            return (T)namedReader.read(this, name);
        }
        return reader.read(this);
    }

    public <T> T readOptionalNamed(Class<T> type) throws IOException {
        if (this.readBoolean()) {
            T t = this.readNamed(type);
            if (t == null) {
                PlanStreamInput.throwOnNullOptionalRead(type);
            }
            return t;
        }
        return null;
    }

    public EsqlConfiguration configuration() throws IOException {
        return this.configuration;
    }

    public Block readCachedBlock() throws IOException {
        byte key = this.readByte();
        Block block = switch (key) {
            case 0 -> {
                int id = this.readVInt();
                Block b = (Block)new BlockStreamInput((StreamInput)this, new BlockFactory((CircuitBreaker)new NoopCircuitBreaker("request"), BigArrays.NON_RECYCLING_INSTANCE)).readNamedWriteable(Block.class);
                this.cachedBlocks.put(id, b);
                yield b;
            }
            case 1 -> this.cachedBlocks.get(this.readVInt());
            case 2 -> {
                String tableName = this.readString();
                Map<String, Column> table = this.configuration.tables().get(tableName);
                if (table == null) {
                    throw new IOException("can't find table [" + tableName + "]");
                }
                String columnName = this.readString();
                Column column = table.get(columnName);
                if (column == null) {
                    throw new IOException("can't find column[" + columnName + "]");
                }
                yield column.values();
            }
            default -> throw new IOException("invalid encoding for Block");
        };
        assert (!(block instanceof LongBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof IntBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof DoubleBigArrayBlock)) : "BigArrays not supported because we don't close";
        assert (!(block instanceof BooleanBigArrayBlock)) : "BigArrays not supported because we don't close";
        return block;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Block[] readCachedBlockArray() throws IOException {
        int len = this.readArraySize();
        if (len == 0) {
            return BlockUtils.NO_BLOCKS;
        }
        Block[] blocks = new Block[len];
        try {
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = this.readCachedBlock();
            }
            Block[] blockArray = blocks;
            return blockArray;
        }
        finally {
            if (blocks[blocks.length - 1] == null) {
                Releasables.closeExpectNoException((Releasable[])blocks);
            }
        }
    }

    public String sourceText() {
        return this.configuration.query();
    }

    static void throwOnNullOptionalRead(Class<?> type) throws IOException {
        IOException e = new IOException("read optional named returned null which is not allowed, type:" + type);
        assert (false) : e;
        throw e;
    }

    public NameId mapNameId(long l) {
        return this.nameIdFunction.apply(l);
    }

    static final class NameIdMapper
    implements LongFunction<NameId> {
        final Map<Long, NameId> seen = new HashMap<Long, NameId>();

        NameIdMapper() {
        }

        @Override
        public NameId apply(long streamNameId) {
            return this.seen.computeIfAbsent(streamNameId, k -> new NameId());
        }
    }
}

