/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.expression.Order;
import org.elasticsearch.xpack.esql.core.index.EsIndex;
import org.elasticsearch.xpack.esql.core.plan.logical.Filter;
import org.elasticsearch.xpack.esql.core.plan.logical.Limit;
import org.elasticsearch.xpack.esql.core.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.core.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.EsField;
import org.elasticsearch.xpack.esql.expression.Order;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.Lookup;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.logical.join.Join;
import org.elasticsearch.xpack.esql.plan.logical.local.EsqlProject;
import org.elasticsearch.xpack.esql.plan.logical.local.LocalRelation;
import org.elasticsearch.xpack.esql.plan.physical.AggregateExec;
import org.elasticsearch.xpack.esql.plan.physical.DissectExec;
import org.elasticsearch.xpack.esql.plan.physical.EnrichExec;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EvalExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FieldExtractExec;
import org.elasticsearch.xpack.esql.plan.physical.FilterExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.GrokExec;
import org.elasticsearch.xpack.esql.plan.physical.HashJoinExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.LocalSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.MvExpandExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.ProjectExec;
import org.elasticsearch.xpack.esql.plan.physical.RowExec;
import org.elasticsearch.xpack.esql.plan.physical.ShowExec;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;

public final class PlanNamedTypes {
    private PlanNamedTypes() {
    }

    public static String name(Class<?> cls) {
        return cls.getSimpleName();
    }

    public static List<PlanNameRegistry.Entry> namedTypeEntries() {
        List<PlanNameRegistry.Entry> declared = List.of(PlanNameRegistry.Entry.of(PhysicalPlan.class, AggregateExec.class, PlanNamedTypes::writeAggregateExec, PlanNamedTypes::readAggregateExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, DissectExec.class, PlanNamedTypes::writeDissectExec, PlanNamedTypes::readDissectExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EsQueryExec.class, PlanNamedTypes::writeEsQueryExec, PlanNamedTypes::readEsQueryExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EsSourceExec.class, PlanNamedTypes::writeEsSourceExec, PlanNamedTypes::readEsSourceExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EvalExec.class, PlanNamedTypes::writeEvalExec, PlanNamedTypes::readEvalExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, EnrichExec.class, PlanNamedTypes::writeEnrichExec, PlanNamedTypes::readEnrichExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeExec.class, PlanNamedTypes::writeExchangeExec, PlanNamedTypes::readExchangeExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeSinkExec.class, PlanNamedTypes::writeExchangeSinkExec, PlanNamedTypes::readExchangeSinkExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ExchangeSourceExec.class, PlanNamedTypes::writeExchangeSourceExec, PlanNamedTypes::readExchangeSourceExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FieldExtractExec.class, PlanNamedTypes::writeFieldExtractExec, PlanNamedTypes::readFieldExtractExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FilterExec.class, PlanNamedTypes::writeFilterExec, PlanNamedTypes::readFilterExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, FragmentExec.class, PlanNamedTypes::writeFragmentExec, PlanNamedTypes::readFragmentExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, GrokExec.class, PlanNamedTypes::writeGrokExec, PlanNamedTypes::readGrokExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, LimitExec.class, PlanNamedTypes::writeLimitExec, PlanNamedTypes::readLimitExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, LocalSourceExec.class, (out, v) -> v.writeTo(out), LocalSourceExec::new), PlanNameRegistry.Entry.of(PhysicalPlan.class, HashJoinExec.class, (out, v) -> v.writeTo(out), HashJoinExec::new), PlanNameRegistry.Entry.of(PhysicalPlan.class, MvExpandExec.class, PlanNamedTypes::writeMvExpandExec, PlanNamedTypes::readMvExpandExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, OrderExec.class, PlanNamedTypes::writeOrderExec, PlanNamedTypes::readOrderExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ProjectExec.class, PlanNamedTypes::writeProjectExec, PlanNamedTypes::readProjectExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, RowExec.class, PlanNamedTypes::writeRowExec, PlanNamedTypes::readRowExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, ShowExec.class, PlanNamedTypes::writeShowExec, PlanNamedTypes::readShowExec), PlanNameRegistry.Entry.of(PhysicalPlan.class, TopNExec.class, PlanNamedTypes::writeTopNExec, PlanNamedTypes::readTopNExec), PlanNameRegistry.Entry.of(LogicalPlan.class, Aggregate.class, Aggregate::writeAggregate, Aggregate::new), PlanNameRegistry.Entry.of(LogicalPlan.class, Dissect.class, PlanNamedTypes::writeDissect, PlanNamedTypes::readDissect), PlanNameRegistry.Entry.of(LogicalPlan.class, EsRelation.class, PlanNamedTypes::writeEsRelation, PlanNamedTypes::readEsRelation), PlanNameRegistry.Entry.of(LogicalPlan.class, Eval.class, PlanNamedTypes::writeEval, PlanNamedTypes::readEval), PlanNameRegistry.Entry.of(LogicalPlan.class, Enrich.class, PlanNamedTypes::writeEnrich, PlanNamedTypes::readEnrich), PlanNameRegistry.Entry.of(LogicalPlan.class, EsqlProject.class, PlanNamedTypes::writeEsqlProject, PlanNamedTypes::readEsqlProject), PlanNameRegistry.Entry.of(LogicalPlan.class, Filter.class, PlanNamedTypes::writeFilter, PlanNamedTypes::readFilter), PlanNameRegistry.Entry.of(LogicalPlan.class, Grok.class, PlanNamedTypes::writeGrok, PlanNamedTypes::readGrok), PlanNameRegistry.Entry.of(LogicalPlan.class, Join.class, (out, p) -> p.writeTo(out), Join::new), PlanNameRegistry.Entry.of(LogicalPlan.class, Limit.class, PlanNamedTypes::writeLimit, PlanNamedTypes::readLimit), PlanNameRegistry.Entry.of(LogicalPlan.class, LocalRelation.class, (out, p) -> p.writeTo(out), LocalRelation::new), PlanNameRegistry.Entry.of(LogicalPlan.class, Lookup.class, (out, p) -> p.writeTo(out), Lookup::new), PlanNameRegistry.Entry.of(LogicalPlan.class, MvExpand.class, PlanNamedTypes::writeMvExpand, PlanNamedTypes::readMvExpand), PlanNameRegistry.Entry.of(LogicalPlan.class, OrderBy.class, PlanNamedTypes::writeOrderBy, PlanNamedTypes::readOrderBy), PlanNameRegistry.Entry.of(LogicalPlan.class, Project.class, PlanNamedTypes::writeProject, PlanNamedTypes::readProject), PlanNameRegistry.Entry.of(LogicalPlan.class, TopN.class, PlanNamedTypes::writeTopN, PlanNamedTypes::readTopN));
        return declared;
    }

    static AggregateExec readAggregateExec(PlanStreamInput in) throws IOException {
        return new AggregateExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readNamedWriteableCollectionAsList(Expression.class), in.readNamedWriteableCollectionAsList(NamedExpression.class), (AggregateExec.Mode)in.readEnum(AggregateExec.Mode.class), in.readOptionalVInt());
    }

    static void writeAggregateExec(PlanStreamOutput out, AggregateExec aggregateExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(aggregateExec.child());
        out.writeNamedWriteableCollection(aggregateExec.groupings());
        out.writeNamedWriteableCollection(aggregateExec.aggregates());
        out.writeEnum(aggregateExec.getMode());
        out.writeOptionalVInt(aggregateExec.estimatedRowSize());
    }

    static DissectExec readDissectExec(PlanStreamInput in) throws IOException {
        return new DissectExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class), PlanNamedTypes.readDissectParser(in), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    static void writeDissectExec(PlanStreamOutput out, DissectExec dissectExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(dissectExec.child());
        out.writeNamedWriteable((NamedWriteable)dissectExec.inputExpression());
        PlanNamedTypes.writeDissectParser(out, dissectExec.parser());
        out.writeNamedWriteableCollection(dissectExec.extractedFields());
    }

    static EsQueryExec readEsQueryExec(PlanStreamInput in) throws IOException {
        return new EsQueryExec(Source.readFrom((StreamInput)in), PlanNamedTypes.readEsIndex(in), PlanNamedTypes.readIndexMode((StreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readOptionalNamed(Expression.class), in.readOptionalCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanNamedTypes::readFieldSort)), in.readOptionalVInt());
    }

    static void writeEsQueryExec(PlanStreamOutput out, EsQueryExec esQueryExec) throws IOException {
        assert (esQueryExec.children().size() == 0);
        Source.EMPTY.writeTo((StreamOutput)out);
        PlanNamedTypes.writeEsIndex(out, esQueryExec.index());
        PlanNamedTypes.writeIndexMode(out, esQueryExec.indexMode());
        out.writeNamedWriteableCollection(esQueryExec.output());
        out.writeOptionalNamedWriteable((NamedWriteable)esQueryExec.query());
        out.writeOptionalNamedWriteable((NamedWriteable)esQueryExec.limit());
        out.writeOptionalCollection(esQueryExec.sorts(), PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanNamedTypes::writeFieldSort));
        out.writeOptionalInt(esQueryExec.estimatedRowSize());
    }

    static EsSourceExec readEsSourceExec(PlanStreamInput in) throws IOException {
        return new EsSourceExec(Source.readFrom((StreamInput)in), PlanNamedTypes.readEsIndex(in), in.readNamedWriteableCollectionAsList(Attribute.class), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), PlanNamedTypes.readIndexMode((StreamInput)in));
    }

    static void writeEsSourceExec(PlanStreamOutput out, EsSourceExec esSourceExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        PlanNamedTypes.writeEsIndex(out, esSourceExec.index());
        out.writeNamedWriteableCollection(esSourceExec.output());
        out.writeOptionalNamedWriteable((NamedWriteable)esSourceExec.query());
        PlanNamedTypes.writeIndexMode(out, esSourceExec.indexMode());
    }

    static IndexMode readIndexMode(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_INDEX_MODE_TO_SOURCE)) {
            return IndexMode.fromString((String)in.readString());
        }
        return IndexMode.STANDARD;
    }

    static void writeIndexMode(StreamOutput out, IndexMode indexMode) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_ADD_INDEX_MODE_TO_SOURCE)) {
            out.writeString(indexMode.getName());
        } else if (indexMode != IndexMode.STANDARD) {
            throw new IllegalStateException("not ready to support index mode [" + indexMode + "]");
        }
    }

    static EvalExec readEvalExec(PlanStreamInput in) throws IOException {
        return new EvalExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readCollectionAsList(Alias::new));
    }

    static void writeEvalExec(PlanStreamOutput out, EvalExec evalExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(evalExec.child());
        out.writeCollection(evalExec.fields());
    }

    static EnrichExec readEnrichExec(PlanStreamInput in) throws IOException {
        Map<String, String> concreteIndices;
        Enrich.Mode mode;
        Source source = Source.readFrom((StreamInput)in);
        PhysicalPlan child = in.readPhysicalPlanNode();
        NamedExpression matchField = (NamedExpression)in.readNamedWriteable(NamedExpression.class);
        String policyName = in.readString();
        String matchType = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_EXTENDED_ENRICH_TYPES) ? in.readString() : "match";
        String policyMatchField = in.readString();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            mode = (Enrich.Mode)in.readEnum(Enrich.Mode.class);
            concreteIndices = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            mode = Enrich.Mode.ANY;
            EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
            if (esIndex.concreteIndices().size() != 1) {
                throw new IllegalStateException("expected a single concrete enrich index; got " + esIndex.concreteIndices());
            }
            concreteIndices = Map.of("", (String)Iterables.get((Iterable)esIndex.concreteIndices(), (int)0));
        }
        return new EnrichExec(source, child, mode, matchType, matchField, policyName, policyMatchField, concreteIndices, in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    static void writeEnrichExec(PlanStreamOutput out, EnrichExec enrich) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(enrich.child());
        out.writeNamedWriteable((NamedWriteable)enrich.matchField());
        out.writeString(enrich.policyName());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_EXTENDED_ENRICH_TYPES)) {
            out.writeString(enrich.matchType());
        }
        out.writeString(enrich.policyMatchField());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeEnum(enrich.mode());
            out.writeMap(enrich.concreteIndices(), StreamOutput::writeString, StreamOutput::writeString);
        } else if (enrich.concreteIndices().keySet().equals(Set.of(""))) {
            String concreteIndex = enrich.concreteIndices().get("");
            PlanNamedTypes.writeEsIndex(out, new EsIndex(concreteIndex, Map.of(), Set.of(concreteIndex)));
        } else {
            throw new IllegalStateException("expected a single concrete enrich index; got " + enrich.concreteIndices());
        }
        out.writeNamedWriteableCollection(enrich.enrichFields());
    }

    static ExchangeExec readExchangeExec(PlanStreamInput in) throws IOException {
        return new ExchangeExec(Source.readFrom((StreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), in.readBoolean(), in.readPhysicalPlanNode());
    }

    static void writeExchangeExec(PlanStreamOutput out, ExchangeExec exchangeExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeNamedWriteableCollection(exchangeExec.output());
        out.writeBoolean(exchangeExec.isInBetweenAggs());
        out.writePhysicalPlanNode(exchangeExec.child());
    }

    static ExchangeSinkExec readExchangeSinkExec(PlanStreamInput in) throws IOException {
        return new ExchangeSinkExec(Source.readFrom((StreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), in.readBoolean(), in.readPhysicalPlanNode());
    }

    static void writeExchangeSinkExec(PlanStreamOutput out, ExchangeSinkExec exchangeSinkExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeNamedWriteableCollection(exchangeSinkExec.output());
        out.writeBoolean(exchangeSinkExec.isIntermediateAgg());
        out.writePhysicalPlanNode(exchangeSinkExec.child());
    }

    static ExchangeSourceExec readExchangeSourceExec(PlanStreamInput in) throws IOException {
        return new ExchangeSourceExec(Source.readFrom((StreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), in.readBoolean());
    }

    static void writeExchangeSourceExec(PlanStreamOutput out, ExchangeSourceExec exchangeSourceExec) throws IOException {
        out.writeNamedWriteableCollection(exchangeSourceExec.output());
        out.writeBoolean(exchangeSourceExec.isIntermediateAgg());
    }

    static FieldExtractExec readFieldExtractExec(PlanStreamInput in) throws IOException {
        return new FieldExtractExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    static void writeFieldExtractExec(PlanStreamOutput out, FieldExtractExec fieldExtractExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(fieldExtractExec.child());
        out.writeNamedWriteableCollection(fieldExtractExec.attributesToExtract());
    }

    static FilterExec readFilterExec(PlanStreamInput in) throws IOException {
        return new FilterExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class));
    }

    static void writeFilterExec(PlanStreamOutput out, FilterExec filterExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(filterExec.child());
        out.writeNamedWriteable((NamedWriteable)filterExec.condition());
    }

    static FragmentExec readFragmentExec(PlanStreamInput in) throws IOException {
        return new FragmentExec(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), (QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class), in.readOptionalVInt(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_REDUCER_NODE_FRAGMENT) ? in.readOptionalPhysicalPlanNode() : null);
    }

    static void writeFragmentExec(PlanStreamOutput out, FragmentExec fragmentExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(fragmentExec.fragment());
        out.writeOptionalNamedWriteable((NamedWriteable)fragmentExec.esFilter());
        out.writeOptionalVInt(fragmentExec.estimatedRowSize());
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_REDUCER_NODE_FRAGMENT)) {
            out.writeOptionalPhysicalPlanNode(fragmentExec.reducer());
        }
    }

    static GrokExec readGrokExec(PlanStreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)in);
        return new GrokExec(source, in.readPhysicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class), Grok.pattern(source, in.readString()), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    static void writeGrokExec(PlanStreamOutput out, GrokExec grokExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(grokExec.child());
        out.writeNamedWriteable((NamedWriteable)grokExec.inputExpression());
        out.writeString(grokExec.pattern().pattern());
        out.writeNamedWriteableCollection(grokExec.extractedFields());
    }

    static LimitExec readLimitExec(PlanStreamInput in) throws IOException {
        return new LimitExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class));
    }

    static void writeLimitExec(PlanStreamOutput out, LimitExec limitExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(limitExec.child());
        out.writeNamedWriteable((NamedWriteable)limitExec.limit());
    }

    static MvExpandExec readMvExpandExec(PlanStreamInput in) throws IOException {
        return new MvExpandExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), (NamedExpression)in.readNamedWriteable(NamedExpression.class), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    static void writeMvExpandExec(PlanStreamOutput out, MvExpandExec mvExpandExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(mvExpandExec.child());
        out.writeNamedWriteable((NamedWriteable)mvExpandExec.target());
        out.writeNamedWriteable((NamedWriteable)mvExpandExec.expanded());
    }

    static OrderExec readOrderExec(PlanStreamInput in) throws IOException {
        return new OrderExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readCollectionAsList(Order::new));
    }

    static void writeOrderExec(PlanStreamOutput out, OrderExec orderExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(orderExec.child());
        out.writeCollection(orderExec.order());
    }

    static ProjectExec readProjectExec(PlanStreamInput in) throws IOException {
        return new ProjectExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    static void writeProjectExec(PlanStreamOutput out, ProjectExec projectExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(projectExec.child());
        out.writeNamedWriteableCollection(projectExec.projections());
    }

    static RowExec readRowExec(PlanStreamInput in) throws IOException {
        return new RowExec(Source.readFrom((StreamInput)in), in.readCollectionAsList(Alias::new));
    }

    static void writeRowExec(PlanStreamOutput out, RowExec rowExec) throws IOException {
        assert (rowExec.children().size() == 0);
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeCollection(rowExec.fields());
    }

    static ShowExec readShowExec(PlanStreamInput in) throws IOException {
        return new ShowExec(Source.readFrom((StreamInput)in), in.readNamedWriteableCollectionAsList(Attribute.class), (List)in.readGenericValue());
    }

    static void writeShowExec(PlanStreamOutput out, ShowExec showExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeNamedWriteableCollection(showExec.output());
        out.writeGenericValue(showExec.values());
    }

    static TopNExec readTopNExec(PlanStreamInput in) throws IOException {
        return new TopNExec(Source.readFrom((StreamInput)in), in.readPhysicalPlanNode(), in.readCollectionAsList(Order::new), (Expression)in.readNamedWriteable(Expression.class), in.readOptionalVInt());
    }

    static void writeTopNExec(PlanStreamOutput out, TopNExec topNExec) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writePhysicalPlanNode(topNExec.child());
        out.writeCollection(topNExec.order());
        out.writeNamedWriteable((NamedWriteable)topNExec.limit());
        out.writeOptionalVInt(topNExec.estimatedRowSize());
    }

    static Dissect readDissect(PlanStreamInput in) throws IOException {
        return new Dissect(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class), PlanNamedTypes.readDissectParser(in), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    static void writeDissect(PlanStreamOutput out, Dissect dissect) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(dissect.child());
        out.writeNamedWriteable((NamedWriteable)dissect.input());
        PlanNamedTypes.writeDissectParser(out, dissect.parser());
        out.writeNamedWriteableCollection(dissect.extractedFields());
    }

    static EsRelation readEsRelation(PlanStreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)in);
        EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
        List attributes = in.readNamedWriteableCollectionAsList(Attribute.class);
        if (PlanNamedTypes.supportingEsSourceOptions(in.getTransportVersion())) {
            PlanNamedTypes.readEsSourceOptions(in);
        }
        IndexMode indexMode = PlanNamedTypes.readIndexMode((StreamInput)in);
        boolean frozen = in.readBoolean();
        return new EsRelation(source, esIndex, attributes, indexMode, frozen);
    }

    static void writeEsRelation(PlanStreamOutput out, EsRelation relation) throws IOException {
        assert (relation.children().size() == 0);
        Source.EMPTY.writeTo((StreamOutput)out);
        PlanNamedTypes.writeEsIndex(out, relation.index());
        out.writeNamedWriteableCollection(relation.output());
        if (PlanNamedTypes.supportingEsSourceOptions(out.getTransportVersion())) {
            PlanNamedTypes.writeEsSourceOptions(out);
        }
        PlanNamedTypes.writeIndexMode(out, relation.indexMode());
        out.writeBoolean(relation.frozen());
    }

    private static boolean supportingEsSourceOptions(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.ESQL_ES_SOURCE_OPTIONS) && version.before((VersionId)TransportVersions.ESQL_REMOVE_ES_SOURCE_OPTIONS);
    }

    private static void readEsSourceOptions(PlanStreamInput in) throws IOException {
        in.readOptionalString();
        in.readOptionalString();
        in.readOptionalString();
    }

    private static void writeEsSourceOptions(PlanStreamOutput out) throws IOException {
        out.writeOptionalString(null);
        out.writeOptionalString(null);
        out.writeOptionalString(null);
    }

    static Eval readEval(PlanStreamInput in) throws IOException {
        return new Eval(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readCollectionAsList(Alias::new));
    }

    static void writeEval(PlanStreamOutput out, Eval eval) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(eval.child());
        out.writeCollection(eval.fields());
    }

    static Enrich readEnrich(PlanStreamInput in) throws IOException {
        Map<String, String> concreteIndices;
        Enrich.Mode mode = Enrich.Mode.ANY;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            mode = (Enrich.Mode)in.readEnum(Enrich.Mode.class);
        }
        Source source = Source.readFrom((StreamInput)in);
        LogicalPlan child = in.readLogicalPlanNode();
        Expression policyName = (Expression)in.readNamedWriteable(Expression.class);
        NamedExpression matchField = (NamedExpression)in.readNamedWriteable(NamedExpression.class);
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_13_0)) {
            in.readString();
        }
        EnrichPolicy policy = new EnrichPolicy((StreamInput)in);
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            concreteIndices = in.readMap(StreamInput::readString, StreamInput::readString);
        } else {
            EsIndex esIndex = PlanNamedTypes.readEsIndex(in);
            if (esIndex.concreteIndices().size() > 1) {
                throw new IllegalStateException("expected a single enrich index; got " + esIndex);
            }
            concreteIndices = Map.of("", (String)Iterables.get((Iterable)esIndex.concreteIndices(), (int)0));
        }
        return new Enrich(source, child, mode, policyName, matchField, policy, concreteIndices, in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    static void writeEnrich(PlanStreamOutput out, Enrich enrich) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeEnum(enrich.mode());
        }
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(enrich.child());
        out.writeNamedWriteable((NamedWriteable)enrich.policyName());
        out.writeNamedWriteable((NamedWriteable)enrich.matchField());
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_13_0)) {
            out.writeString(BytesRefs.toString((Object)enrich.policyName().fold()));
        }
        enrich.policy().writeTo((StreamOutput)out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeMap(enrich.concreteIndices(), StreamOutput::writeString, StreamOutput::writeString);
        } else {
            Map<String, String> concreteIndices = enrich.concreteIndices();
            if (concreteIndices.keySet().equals(Set.of(""))) {
                String enrichIndex = concreteIndices.get("");
                EsIndex esIndex = new EsIndex(enrichIndex, Map.of(), Set.of(enrichIndex));
                PlanNamedTypes.writeEsIndex(out, esIndex);
            } else {
                throw new IllegalStateException("expected a single enrich index; got " + concreteIndices);
            }
        }
        out.writeNamedWriteableCollection(enrich.enrichFields());
    }

    static EsqlProject readEsqlProject(PlanStreamInput in) throws IOException {
        return new EsqlProject(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    static void writeEsqlProject(PlanStreamOutput out, EsqlProject project) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(project.child());
        out.writeNamedWriteableCollection(project.projections());
    }

    static Filter readFilter(PlanStreamInput in) throws IOException {
        return new Filter(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class));
    }

    static void writeFilter(PlanStreamOutput out, Filter filter) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(filter.child());
        out.writeNamedWriteable((NamedWriteable)filter.condition());
    }

    static Grok readGrok(PlanStreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)in);
        return new Grok(source, in.readLogicalPlanNode(), (Expression)in.readNamedWriteable(Expression.class), Grok.pattern(source, in.readString()), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    static void writeGrok(PlanStreamOutput out, Grok grok) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(grok.child());
        out.writeNamedWriteable((NamedWriteable)grok.input());
        out.writeString(grok.parser().pattern());
        out.writeNamedWriteableCollection(grok.extractedFields());
    }

    static Limit readLimit(PlanStreamInput in) throws IOException {
        return new Limit(Source.readFrom((StreamInput)in), (Expression)in.readNamedWriteable(Expression.class), in.readLogicalPlanNode());
    }

    static void writeLimit(PlanStreamOutput out, Limit limit) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeNamedWriteable((NamedWriteable)limit.limit());
        out.writeLogicalPlanNode(limit.child());
    }

    static MvExpand readMvExpand(PlanStreamInput in) throws IOException {
        return new MvExpand(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), (NamedExpression)in.readNamedWriteable(NamedExpression.class), (Attribute)in.readNamedWriteable(Attribute.class));
    }

    static void writeMvExpand(PlanStreamOutput out, MvExpand mvExpand) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(mvExpand.child());
        out.writeNamedWriteable((NamedWriteable)mvExpand.target());
        out.writeNamedWriteable((NamedWriteable)mvExpand.expanded());
    }

    static OrderBy readOrderBy(PlanStreamInput in) throws IOException {
        return new OrderBy(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readCollectionAsList(Order::new));
    }

    static void writeOrderBy(PlanStreamOutput out, OrderBy order) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(order.child());
        out.writeCollection(order.order());
    }

    static Project readProject(PlanStreamInput in) throws IOException {
        return new Project(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readNamedWriteableCollectionAsList(NamedExpression.class));
    }

    static void writeProject(PlanStreamOutput out, Project project) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(project.child());
        out.writeNamedWriteableCollection(project.projections());
    }

    static TopN readTopN(PlanStreamInput in) throws IOException {
        return new TopN(Source.readFrom((StreamInput)in), in.readLogicalPlanNode(), in.readCollectionAsList(Order::new), (Expression)in.readNamedWriteable(Expression.class));
    }

    static void writeTopN(PlanStreamOutput out, TopN topN) throws IOException {
        Source.EMPTY.writeTo((StreamOutput)out);
        out.writeLogicalPlanNode(topN.child());
        out.writeCollection(topN.order());
        out.writeNamedWriteable((NamedWriteable)topN.limit());
    }

    static EsQueryExec.FieldSort readFieldSort(PlanStreamInput in) throws IOException {
        return new EsQueryExec.FieldSort(new FieldAttribute((StreamInput)in), (Order.OrderDirection)in.readEnum(Order.OrderDirection.class), (Order.NullsPosition)in.readEnum(Order.NullsPosition.class));
    }

    static void writeFieldSort(PlanStreamOutput out, EsQueryExec.FieldSort fieldSort) throws IOException {
        fieldSort.field().writeTo((StreamOutput)out);
        out.writeEnum((Enum)fieldSort.direction());
        out.writeEnum((Enum)fieldSort.nulls());
    }

    static EsIndex readEsIndex(PlanStreamInput in) throws IOException {
        return new EsIndex(in.readString(), in.readImmutableMap(StreamInput::readString, i -> (EsField)i.readNamedWriteable(EsField.class)), (Set)in.readGenericValue());
    }

    static void writeEsIndex(PlanStreamOutput out, EsIndex esIndex) throws IOException {
        out.writeString(esIndex.name());
        out.writeMap(esIndex.mapping(), StreamOutput::writeNamedWriteable);
        out.writeGenericValue(esIndex.concreteIndices());
    }

    static Dissect.Parser readDissectParser(PlanStreamInput in) throws IOException {
        String pattern = in.readString();
        String appendSeparator = in.readString();
        return new Dissect.Parser(pattern, appendSeparator, new DissectParser(pattern, appendSeparator));
    }

    static void writeDissectParser(PlanStreamOutput out, Dissect.Parser dissectParser) throws IOException {
        out.writeString(dissectParser.pattern());
        out.writeString(dissectParser.appendSeparator());
    }
}

